/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import org.bouncycastle.pqc.crypto.xmss.XMSSAddress;
import org.bouncycastle.util.Pack;

final class OTSHashAddress
extends XMSSAddress {
    private final int otsAddress;
    private final int chainAddress;
    private final int hashAddress;

    private OTSHashAddress(Builder builder) {
        super(builder);
        this.otsAddress = builder.otsAddress;
        this.chainAddress = builder.chainAddress;
        this.hashAddress = builder.hashAddress;
    }

    protected final byte[] toByteArray() {
        byte[] byArray = super.toByteArray();
        Pack.intToBigEndian(this.otsAddress, byArray, 16);
        Pack.intToBigEndian(this.chainAddress, byArray, 20);
        Pack.intToBigEndian(this.hashAddress, byArray, 24);
        return byArray;
    }

    protected final int getOTSAddress() {
        return this.otsAddress;
    }

    protected final int getChainAddress() {
        return this.chainAddress;
    }

    protected final int getHashAddress() {
        return this.hashAddress;
    }

    /* synthetic */ OTSHashAddress(Builder builder, byte by) {
        this(builder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Builder
    extends XMSSAddress.Builder<Builder> {
        private int otsAddress = 0;
        private int chainAddress = 0;
        private int hashAddress = 0;

        protected Builder() {
            super(0);
        }

        protected final Builder withOTSAddress(int n) {
            this.otsAddress = n;
            return this;
        }

        protected final Builder withChainAddress(int n) {
            this.chainAddress = n;
            return this;
        }

        protected final Builder withHashAddress(int n) {
            this.hashAddress = n;
            return this;
        }

        @Override
        protected final XMSSAddress build() {
            return new OTSHashAddress(this, 0);
        }
    }
}

