/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.xmss.DefaultXMSSMTOid;
import org.bouncycastle.pqc.crypto.xmss.DigestUtil;
import org.bouncycastle.pqc.crypto.xmss.XMSSOid;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;

public final class XMSSMTParameters {
    private static final Map<Integer, XMSSMTParameters> paramsLookupTable;
    private final DefaultXMSSMTOid oid$68c067dd;
    private final XMSSParameters xmssParams;
    private final int height;
    private final int layers;

    public XMSSMTParameters(int n, int n2, Digest digest) {
        this(n, n2, DigestUtil.getDigestOID(digest.getAlgorithmName()));
    }

    private XMSSMTParameters(int n, int n2, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.height = n;
        this.layers = n2;
        int n3 = n2;
        if (n < 2) {
            throw new IllegalArgumentException("totalHeight must be > 1");
        }
        if (n % n3 != 0) {
            throw new IllegalArgumentException("layers must divide totalHeight without remainder");
        }
        if (n / n3 == 1) {
            throw new IllegalArgumentException("height / layers must be greater than 1");
        }
        this.xmssParams = new XMSSParameters(n / n3, aSN1ObjectIdentifier);
        XMSSMTParameters xMSSMTParameters = this;
        XMSSMTParameters xMSSMTParameters2 = xMSSMTParameters;
        XMSSMTParameters xMSSMTParameters3 = this;
        xMSSMTParameters2 = xMSSMTParameters3;
        XMSSMTParameters xMSSMTParameters4 = this;
        xMSSMTParameters2 = xMSSMTParameters4;
        XMSSMTParameters xMSSMTParameters5 = this;
        xMSSMTParameters2 = xMSSMTParameters5;
        xMSSMTParameters2 = this;
        xMSSMTParameters.oid$68c067dd = DefaultXMSSMTOid.lookup(xMSSMTParameters.xmssParams.getTreeDigest(), xMSSMTParameters3.xmssParams.getTreeDigestSize(), xMSSMTParameters4.xmssParams.getWinternitzParameter(), xMSSMTParameters5.xmssParams.getLen(), xMSSMTParameters2.height, n2);
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getLayers() {
        return this.layers;
    }

    protected final XMSSParameters getXMSSParameters() {
        return this.xmssParams;
    }

    protected final String getTreeDigest() {
        return this.xmssParams.getTreeDigest();
    }

    public final int getTreeDigestSize() {
        return this.xmssParams.getTreeDigestSize();
    }

    protected final XMSSOid getOid() {
        return this.oid$68c067dd;
    }

    public static XMSSMTParameters lookupByOID(int n) {
        return paramsLookupTable.get(n);
    }

    static {
        HashMap<Integer, XMSSMTParameters> hashMap = new HashMap<Integer, XMSSMTParameters>();
        int n = 1;
        hashMap.put(1, new XMSSMTParameters(20, 2, NISTObjectIdentifiers.id_sha256));
        n = 2;
        hashMap.put(2, new XMSSMTParameters(20, 4, NISTObjectIdentifiers.id_sha256));
        n = 3;
        hashMap.put(3, new XMSSMTParameters(40, 2, NISTObjectIdentifiers.id_sha256));
        n = 4;
        hashMap.put(4, new XMSSMTParameters(40, 4, NISTObjectIdentifiers.id_sha256));
        n = 5;
        hashMap.put(5, new XMSSMTParameters(40, 8, NISTObjectIdentifiers.id_sha256));
        n = 6;
        hashMap.put(6, new XMSSMTParameters(60, 3, NISTObjectIdentifiers.id_sha256));
        n = 7;
        hashMap.put(7, new XMSSMTParameters(60, 6, NISTObjectIdentifiers.id_sha256));
        n = 8;
        hashMap.put(8, new XMSSMTParameters(60, 12, NISTObjectIdentifiers.id_sha256));
        n = 9;
        hashMap.put(9, new XMSSMTParameters(20, 2, NISTObjectIdentifiers.id_sha512));
        n = 10;
        hashMap.put(10, new XMSSMTParameters(20, 4, NISTObjectIdentifiers.id_sha512));
        n = 11;
        hashMap.put(11, new XMSSMTParameters(40, 2, NISTObjectIdentifiers.id_sha512));
        n = 12;
        hashMap.put(12, new XMSSMTParameters(40, 4, NISTObjectIdentifiers.id_sha512));
        n = 13;
        hashMap.put(13, new XMSSMTParameters(40, 8, NISTObjectIdentifiers.id_sha512));
        n = 14;
        hashMap.put(14, new XMSSMTParameters(60, 3, NISTObjectIdentifiers.id_sha512));
        n = 15;
        hashMap.put(15, new XMSSMTParameters(60, 6, NISTObjectIdentifiers.id_sha512));
        n = 16;
        hashMap.put(16, new XMSSMTParameters(60, 12, NISTObjectIdentifiers.id_sha512));
        n = 17;
        hashMap.put(17, new XMSSMTParameters(20, 2, NISTObjectIdentifiers.id_shake128));
        n = 18;
        hashMap.put(18, new XMSSMTParameters(20, 4, NISTObjectIdentifiers.id_shake128));
        n = 19;
        hashMap.put(19, new XMSSMTParameters(40, 2, NISTObjectIdentifiers.id_shake128));
        n = 20;
        hashMap.put(20, new XMSSMTParameters(40, 4, NISTObjectIdentifiers.id_shake128));
        n = 21;
        hashMap.put(21, new XMSSMTParameters(40, 8, NISTObjectIdentifiers.id_shake128));
        n = 22;
        hashMap.put(22, new XMSSMTParameters(60, 3, NISTObjectIdentifiers.id_shake128));
        n = 23;
        hashMap.put(23, new XMSSMTParameters(60, 6, NISTObjectIdentifiers.id_shake128));
        n = 24;
        hashMap.put(24, new XMSSMTParameters(60, 12, NISTObjectIdentifiers.id_shake128));
        n = 25;
        hashMap.put(25, new XMSSMTParameters(20, 2, NISTObjectIdentifiers.id_shake256));
        n = 26;
        hashMap.put(26, new XMSSMTParameters(20, 4, NISTObjectIdentifiers.id_shake256));
        n = 27;
        hashMap.put(27, new XMSSMTParameters(40, 2, NISTObjectIdentifiers.id_shake256));
        n = 28;
        hashMap.put(28, new XMSSMTParameters(40, 4, NISTObjectIdentifiers.id_shake256));
        n = 29;
        hashMap.put(29, new XMSSMTParameters(40, 8, NISTObjectIdentifiers.id_shake256));
        n = 30;
        hashMap.put(30, new XMSSMTParameters(60, 3, NISTObjectIdentifiers.id_shake256));
        n = 31;
        hashMap.put(31, new XMSSMTParameters(60, 6, NISTObjectIdentifiers.id_shake256));
        n = 32;
        hashMap.put(32, new XMSSMTParameters(60, 12, NISTObjectIdentifiers.id_shake256));
        paramsLookupTable = Collections.unmodifiableMap(hashMap);
    }
}

