/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.io.IOException;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import org.bouncycastle.util.Encodable;
import org.bouncycastle.util.Pack;

public final class XMSSMTPublicKeyParameters
extends XMSSMTKeyParameters
implements Encodable {
    private final XMSSMTParameters params;
    private final int oid;
    private final byte[] root;
    private final byte[] publicSeed;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XMSSMTPublicKeyParameters(Builder object) {
        super(false, ((Builder)object).params.getTreeDigest());
        this.params = ((Builder)object).params;
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n = this.params.getTreeDigestSize();
        byte[] byArray = ((Builder)object).publicKey;
        if (byArray != null) {
            int n2 = n;
            if (byArray.length == n2 + n) {
                this.oid = 0;
                this.root = XMSSUtil.extractBytesAtOffset(byArray, 0, n2);
                this.publicSeed = XMSSUtil.extractBytesAtOffset(byArray, n2 += 0, n);
                return;
            } else {
                if (byArray.length != n2 + 4 + n) throw new IllegalArgumentException("public key has wrong size");
                this.oid = Pack.bigEndianToInt(byArray, 0);
                this.root = XMSSUtil.extractBytesAtOffset(byArray, 4, n2);
                this.publicSeed = XMSSUtil.extractBytesAtOffset(byArray, n2 += 4, n);
            }
            return;
        } else {
            this.oid = this.params.getOid() != null ? this.params.getOid().getOid() : 0;
            byArray = ((Builder)object).root;
            if (byArray != null) {
                if (byArray.length != n) {
                    throw new IllegalArgumentException("length of root must be equal to length of digest");
                }
                this.root = byArray;
            } else {
                this.root = new byte[n];
            }
            byte[] byArray2 = ((Builder)object).publicSeed;
            object = byArray2;
            if (byArray2 != null) {
                if (((Object)object).length != n) {
                    throw new IllegalArgumentException("length of publicSeed must be equal to length of digest");
                }
                this.publicSeed = (byte[])object;
                return;
            }
            this.publicSeed = new byte[n];
        }
    }

    public final byte[] getEncoded() throws IOException {
        return this.toByteArray();
    }

    public final byte[] toByteArray() {
        byte[] byArray;
        int n;
        int n2 = n = this.params.getTreeDigestSize();
        int n3 = 0;
        if (this.oid != 0) {
            byArray = new byte[n2 + 4 + n];
            Pack.intToBigEndian(this.oid, byArray, 0);
            n3 = 4;
        } else {
            byArray = new byte[n2 + n];
        }
        XMSSUtil.copyBytesAtOffset(byArray, this.root, n3);
        XMSSUtil.copyBytesAtOffset(byArray, this.publicSeed, n3 += n2);
        return byArray;
    }

    public final byte[] getRoot() {
        return XMSSUtil.cloneArray(this.root);
    }

    public final byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.publicSeed);
    }

    public final XMSSMTParameters getParameters() {
        return this.params;
    }

    /* synthetic */ XMSSMTPublicKeyParameters(Builder builder, byte by) {
        this(builder);
    }

    public static final class Builder {
        private final XMSSMTParameters params;
        private byte[] root = null;
        private byte[] publicSeed = null;
        private byte[] publicKey = null;

        public Builder(XMSSMTParameters xMSSMTParameters) {
            this.params = xMSSMTParameters;
        }

        public final Builder withRoot(byte[] byArray) {
            this.root = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public final Builder withPublicSeed(byte[] byArray) {
            this.publicSeed = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public final Builder withPublicKey(byte[] byArray) {
            this.publicKey = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public final XMSSMTPublicKeyParameters build() {
            return new XMSSMTPublicKeyParameters(this, 0);
        }
    }
}

