/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.pqc.crypto.xmss.DefaultXMSSOid;
import org.bouncycastle.pqc.crypto.xmss.DigestUtil;
import org.bouncycastle.pqc.crypto.xmss.WOTSPlus;
import org.bouncycastle.pqc.crypto.xmss.WOTSPlusParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSOid;

public final class XMSSParameters {
    private static final Map<Integer, XMSSParameters> paramsLookupTable;
    private final DefaultXMSSOid oid$68c067dd;
    private final int height;
    private final int k;
    private final ASN1ObjectIdentifier treeDigestOID;
    private final int winternitzParameter;
    private final String treeDigest;
    private final int treeDigestSize;
    private final WOTSPlusParameters wotsPlusParams;

    public XMSSParameters(int n, Digest digest) {
        this(n, DigestUtil.getDigestOID(digest.getAlgorithmName()));
    }

    public XMSSParameters(int n, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        int n2;
        block4: {
            if (n < 2) {
                throw new IllegalArgumentException("height must be >= 2");
            }
            if (aSN1ObjectIdentifier == null) {
                throw new NullPointerException("digest == null");
            }
            this.height = n;
            XMSSParameters xMSSParameters = this;
            for (n2 = 2; n2 <= xMSSParameters.height; ++n2) {
                if ((xMSSParameters.height - n2) % 2 != 0) {
                    continue;
                }
                break block4;
            }
            throw new IllegalStateException("should never happen...");
        }
        this.k = n2;
        this.treeDigest = DigestUtil.getDigestName(aSN1ObjectIdentifier);
        this.treeDigestOID = aSN1ObjectIdentifier;
        this.wotsPlusParams = new WOTSPlusParameters(aSN1ObjectIdentifier);
        this.treeDigestSize = this.wotsPlusParams.getTreeDigestSize();
        this.winternitzParameter = this.wotsPlusParams.getWinternitzParameter();
        this.oid$68c067dd = DefaultXMSSOid.lookup(this.treeDigest, this.treeDigestSize, this.winternitzParameter, this.wotsPlusParams.getLen(), n);
    }

    public final int getTreeDigestSize() {
        return this.treeDigestSize;
    }

    public final ASN1ObjectIdentifier getTreeDigestOID() {
        return this.treeDigestOID;
    }

    public final int getHeight() {
        return this.height;
    }

    final String getTreeDigest() {
        return this.treeDigest;
    }

    final int getLen() {
        return this.wotsPlusParams.getLen();
    }

    final int getWinternitzParameter() {
        return this.winternitzParameter;
    }

    final WOTSPlus getWOTSPlus() {
        return new WOTSPlus(this.wotsPlusParams);
    }

    final XMSSOid getOid() {
        return this.oid$68c067dd;
    }

    final int getK() {
        return this.k;
    }

    public static XMSSParameters lookupByOID(int n) {
        return paramsLookupTable.get(n);
    }

    static {
        HashMap<Integer, XMSSParameters> hashMap = new HashMap<Integer, XMSSParameters>();
        int n = 1;
        hashMap.put(1, new XMSSParameters(10, NISTObjectIdentifiers.id_sha256));
        n = 2;
        hashMap.put(2, new XMSSParameters(16, NISTObjectIdentifiers.id_sha256));
        n = 3;
        hashMap.put(3, new XMSSParameters(20, NISTObjectIdentifiers.id_sha256));
        n = 4;
        hashMap.put(4, new XMSSParameters(10, NISTObjectIdentifiers.id_sha512));
        n = 5;
        hashMap.put(5, new XMSSParameters(16, NISTObjectIdentifiers.id_sha512));
        n = 6;
        hashMap.put(6, new XMSSParameters(20, NISTObjectIdentifiers.id_sha512));
        n = 7;
        hashMap.put(7, new XMSSParameters(10, NISTObjectIdentifiers.id_shake128));
        n = 8;
        hashMap.put(8, new XMSSParameters(16, NISTObjectIdentifiers.id_shake128));
        n = 9;
        hashMap.put(9, new XMSSParameters(20, NISTObjectIdentifiers.id_shake128));
        n = 10;
        hashMap.put(10, new XMSSParameters(10, NISTObjectIdentifiers.id_shake256));
        n = 11;
        hashMap.put(11, new XMSSParameters(16, NISTObjectIdentifiers.id_shake256));
        n = 12;
        hashMap.put(12, new XMSSParameters(20, NISTObjectIdentifiers.id_shake256));
        paramsLookupTable = Collections.unmodifiableMap(hashMap);
    }
}

