/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.lms;

import java.io.IOException;
import java.security.PrivateKey;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.jcajce.interfaces.LMSPrivateKey;
import org.bouncycastle.util.Arrays;

public final class BCLMSPrivateKey
implements PrivateKey,
LMSPrivateKey {
    private transient LMSKeyParameters keyParams;
    private transient ASN1Set attributes;

    public BCLMSPrivateKey(PrivateKeyInfo object) throws IOException {
        PrivateKeyInfo privateKeyInfo = object;
        object = this;
        this.attributes = privateKeyInfo.getAttributes();
        ((BCLMSPrivateKey)object).keyParams = (LMSKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public final String getAlgorithm() {
        return "LMS";
    }

    public final String getFormat() {
        return "PKCS#8";
    }

    public final byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.keyParams, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCLMSPrivateKey) {
            object = (BCLMSPrivateKey)object;
            try {
                byte[] byArray = this.keyParams.getEncoded();
                byte[] byArray2 = ((BCLMSPrivateKey)object).keyParams.getEncoded();
                object = byArray;
                return java.util.Arrays.equals(byArray, byArray2);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("unable to perform equals");
            }
        }
        return false;
    }

    public final int hashCode() {
        try {
            return Arrays.hashCode(this.keyParams.getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to calculate hashCode");
        }
    }
}

