/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.mceliece;

import java.io.IOException;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.pqc.asn1.McEliecePublicKey;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;

public final class BCMcEliecePublicKey
implements PublicKey {
    private McEliecePublicKeyParameters params;

    public BCMcEliecePublicKey(McEliecePublicKeyParameters mcEliecePublicKeyParameters) {
        this.params = mcEliecePublicKeyParameters;
    }

    public final String getAlgorithm() {
        return "McEliece";
    }

    public final String toString() {
        String string = "McEliecePublicKey:\n";
        string = string + " length of the code         : " + this.params.getN() + "\n";
        string = string + " error correction capability: " + this.params.getT() + "\n";
        string = string + " generator matrix           : " + this.params.getG();
        return string;
    }

    public final boolean equals(Object object) {
        if (object instanceof BCMcEliecePublicKey) {
            Object object2 = object = (BCMcEliecePublicKey)object;
            if (this.params.getN() == ((BCMcEliecePublicKey)object2).params.getN()) {
                object2 = object;
                if (this.params.getT() == ((BCMcEliecePublicKey)object2).params.getT()) {
                    object2 = object;
                    if (this.params.getG().equals(((BCMcEliecePublicKey)object2).params.getG())) {
                        return true;
                    }
                }
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        return 37 * (this.params.getN() + 37 * this.params.getT()) + this.params.getG().hashCode();
    }

    public final byte[] getEncoded() {
        ASN1Object aSN1Object = new McEliecePublicKey(this.params.getN(), this.params.getT(), this.params.getG());
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcEliece);
        try {
            aSN1Object = new SubjectPublicKeyInfo(algorithmIdentifier, aSN1Object);
            return aSN1Object.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final String getFormat() {
        return "X.509";
    }
}

