/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.mceliece;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import org.bouncycastle.pqc.asn1.McEliecePrivateKey;
import org.bouncycastle.pqc.asn1.McEliecePublicKey;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePrivateKey;
import org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcEliecePublicKey;

public final class McElieceKeyFactorySpi
extends KeyFactorySpi
implements AsymmetricKeyInfoConverter {
    protected final PublicKey engineGeneratePublic(KeySpec object) throws InvalidKeySpecException {
        if (object instanceof X509EncodedKeySpec) {
            object = ((X509EncodedKeySpec)object).getEncoded();
            try {
                object = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException(iOException.toString());
            }
            try {
                if (PQCObjectIdentifiers.mcEliece.equals(((SubjectPublicKeyInfo)object).getAlgorithm().getAlgorithm())) {
                    object = McEliecePublicKey.getInstance$5d33befc(((SubjectPublicKeyInfo)object).parsePublicKey());
                    return new BCMcEliecePublicKey(new McEliecePublicKeyParameters(((McEliecePublicKey)object).getN(), ((McEliecePublicKey)object).getT(), ((McEliecePublicKey)object).getG()));
                }
                throw new InvalidKeySpecException("Unable to recognise OID in McEliece public key");
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Unable to decode X509EncodedKeySpec: " + iOException.getMessage());
            }
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + object.getClass() + ".");
    }

    protected final PrivateKey engineGeneratePrivate(KeySpec object) throws InvalidKeySpecException {
        if (object instanceof PKCS8EncodedKeySpec) {
            object = ((PKCS8EncodedKeySpec)object).getEncoded();
            try {
                object = PrivateKeyInfo.getInstance$57c4e802(ASN1Primitive.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec: " + iOException);
            }
            try {
                if (PQCObjectIdentifiers.mcEliece.equals(((PrivateKeyInfo)object).getPrivateKeyAlgorithm().getAlgorithm())) {
                    object = McEliecePrivateKey.getInstance$6dbd2c80(((PrivateKeyInfo)object).parsePrivateKey$7b6dd9a4());
                    return new BCMcEliecePrivateKey(new McEliecePrivateKeyParameters(((McEliecePrivateKey)object).getN(), ((McEliecePrivateKey)object).getK(), ((McEliecePrivateKey)object).getField(), ((McEliecePrivateKey)object).getGoppaPoly(), ((McEliecePrivateKey)object).getP1(), ((McEliecePrivateKey)object).getP2(), ((McEliecePrivateKey)object).getSInv()));
                }
                throw new InvalidKeySpecException("Unable to recognise OID in McEliece private key");
            }
            catch (IOException iOException) {
                throw new InvalidKeySpecException("Unable to decode PKCS8EncodedKeySpec.");
            }
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + object.getClass() + ".");
    }

    protected final KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        return null;
    }

    protected final Key engineTranslateKey(Key key) throws InvalidKeyException {
        return null;
    }
}

