/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.qtesla;

import java.io.IOException;
import java.security.PrivateKey;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.util.Arrays;

public final class BCqTESLAPrivateKey
implements PrivateKey {
    private transient QTESLAPrivateKeyParameters keyParams;
    private transient ASN1Set attributes;

    public BCqTESLAPrivateKey(PrivateKeyInfo object) throws IOException {
        PrivateKeyInfo privateKeyInfo = object;
        object = this;
        this.attributes = privateKeyInfo.getAttributes();
        ((BCqTESLAPrivateKey)object).keyParams = (QTESLAPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public final String getAlgorithm() {
        return QTESLASecurityCategory.getName(this.keyParams.getSecurityCategory());
    }

    public final String getFormat() {
        return "PKCS#8";
    }

    public final byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.keyParams, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCqTESLAPrivateKey) {
            object = (BCqTESLAPrivateKey)object;
            if (this.keyParams.getSecurityCategory() == ((BCqTESLAPrivateKey)object).keyParams.getSecurityCategory()) {
                byte[] byArray = this.keyParams.getSecret();
                byte[] byArray2 = ((BCqTESLAPrivateKey)object).keyParams.getSecret();
                object = byArray;
                if (java.util.Arrays.equals(byArray, byArray2)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        return this.keyParams.getSecurityCategory() + 37 * Arrays.hashCode(this.keyParams.getSecret());
    }
}

