/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.rainbow;

import java.io.IOException;
import java.security.PrivateKey;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.asn1.RainbowPrivateKey;
import org.bouncycastle.pqc.crypto.rainbow.Layer;
import org.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;
import org.bouncycastle.pqc.jcajce.spec.RainbowPrivateKeySpec;
import org.bouncycastle.util.Arrays;

public final class BCRainbowPrivateKey
implements PrivateKey {
    private short[][] A1inv;
    private short[] b1;
    private short[][] A2inv;
    private short[] b2;
    private Layer[] layers;
    private int[] vi;

    public BCRainbowPrivateKey(short[][] sArray, short[] sArray2, short[][] sArray3, short[] sArray4, int[] nArray, Layer[] layerArray) {
        this.A1inv = sArray;
        this.b1 = sArray2;
        this.A2inv = sArray3;
        this.b2 = sArray4;
        this.vi = nArray;
        this.layers = layerArray;
    }

    public BCRainbowPrivateKey(RainbowPrivateKeySpec rainbowPrivateKeySpec) {
        this(rainbowPrivateKeySpec.getInvA1(), rainbowPrivateKeySpec.getB1(), rainbowPrivateKeySpec.getInvA2(), rainbowPrivateKeySpec.getB2(), rainbowPrivateKeySpec.getVi(), rainbowPrivateKeySpec.getLayers());
    }

    public final short[][] getInvA1() {
        return this.A1inv;
    }

    public final short[] getB1() {
        return this.b1;
    }

    public final short[] getB2() {
        return this.b2;
    }

    public final short[][] getInvA2() {
        return this.A2inv;
    }

    public final Layer[] getLayers() {
        return this.layers;
    }

    public final int[] getVi() {
        return this.vi;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean equals(Object var1_1) {
        if (var1_1 == null || !(var1_1 instanceof BCRainbowPrivateKey)) {
            return false;
        }
        var4_2 = var1_1 = (BCRainbowPrivateKey)var1_1;
        var2_3 = RainbowUtil.equals(this.A1inv, var4_2.A1inv) != false;
        if (!var2_3) ** GOTO lbl-1000
        var4_2 = var1_1;
        if (RainbowUtil.equals(this.A2inv, var4_2.A2inv)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var2_3 = false;
        }
        if (!v0) ** GOTO lbl-1000
        var4_2 = var1_1;
        if (RainbowUtil.equals(this.b1, var4_2.b1)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = var2_3 = false;
        }
        if (!v1) ** GOTO lbl-1000
        var4_2 = var1_1;
        if (RainbowUtil.equals(this.b2, var4_2.b2)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = var2_3 = false;
        }
        if (!v2) ** GOTO lbl-1000
        var4_2 = var1_1;
        if (java.util.Arrays.equals(this.vi, var4_2.vi)) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        var2_3 = v3;
        var4_2 = var1_1;
        if (this.layers.length != var4_2.layers.length) {
            return false;
        }
        for (var3_4 = this.layers.length - 1; var3_4 >= 0; --var3_4) {
            var4_2 = var1_1;
            var2_3 &= this.layers[var3_4].equals(var4_2.layers[var3_4]);
        }
        return var2_3;
    }

    public final int hashCode() {
        int n = this.layers.length;
        n = n * 37 + Arrays.hashCode(this.A1inv);
        n = n * 37 + Arrays.hashCode(this.b1);
        n = n * 37 + Arrays.hashCode(this.A2inv);
        n = n * 37 + Arrays.hashCode(this.b2);
        n = n * 37 + Arrays.hashCode(this.vi);
        for (int i = this.layers.length - 1; i >= 0; --i) {
            n = n * 37 + this.layers[i].hashCode();
        }
        return n;
    }

    public final String getAlgorithm() {
        return "Rainbow";
    }

    public final byte[] getEncoded() {
        Object object;
        ASN1Object aSN1Object = new RainbowPrivateKey(this.A1inv, this.b1, this.A2inv, this.b2, this.vi, this.layers);
        try {
            object = new AlgorithmIdentifier(PQCObjectIdentifiers.rainbow, DERNull.INSTANCE);
            aSN1Object = new PrivateKeyInfo((AlgorithmIdentifier)object, aSN1Object);
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            byte[] byArray = aSN1Object.getEncoded();
            object = byArray;
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final String getFormat() {
        return "PKCS#8";
    }
}

