/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.rainbow;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import org.bouncycastle.pqc.asn1.RainbowPrivateKey;
import org.bouncycastle.pqc.asn1.RainbowPublicKey;
import org.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPrivateKey;
import org.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPublicKey;
import org.bouncycastle.pqc.jcajce.spec.RainbowPrivateKeySpec;
import org.bouncycastle.pqc.jcajce.spec.RainbowPublicKeySpec;

public final class RainbowKeyFactorySpi
extends KeyFactorySpi
implements AsymmetricKeyInfoConverter {
    public final PrivateKey engineGeneratePrivate(KeySpec object) throws InvalidKeySpecException {
        if (object instanceof RainbowPrivateKeySpec) {
            return new BCRainbowPrivateKey((RainbowPrivateKeySpec)object);
        }
        if (object instanceof PKCS8EncodedKeySpec) {
            object = ((PKCS8EncodedKeySpec)object).getEncoded();
            try {
                object = PrivateKeyInfo.getInstance$57c4e802(ASN1Primitive.fromByteArray((byte[])object));
                object = RainbowPrivateKey.getInstance$34d83c4d(((PrivateKeyInfo)object).parsePrivateKey$7b6dd9a4());
                return new BCRainbowPrivateKey(((RainbowPrivateKey)object).getInvA1(), ((RainbowPrivateKey)object).getB1(), ((RainbowPrivateKey)object).getInvA2(), ((RainbowPrivateKey)object).getB2(), ((RainbowPrivateKey)object).getVi(), ((RainbowPrivateKey)object).getLayers());
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(exception.toString());
            }
        }
        throw new InvalidKeySpecException("Unsupported key specification: " + object.getClass() + ".");
    }

    public final PublicKey engineGeneratePublic(KeySpec object) throws InvalidKeySpecException {
        if (object instanceof RainbowPublicKeySpec) {
            return new BCRainbowPublicKey((RainbowPublicKeySpec)object);
        }
        if (object instanceof X509EncodedKeySpec) {
            object = ((X509EncodedKeySpec)object).getEncoded();
            try {
                object = SubjectPublicKeyInfo.getInstance(object);
                object = RainbowPublicKey.getInstance$2d598397(((SubjectPublicKeyInfo)object).parsePublicKey());
                return new BCRainbowPublicKey(((RainbowPublicKey)object).getDocLength(), ((RainbowPublicKey)object).getCoeffQuadratic(), ((RainbowPublicKey)object).getCoeffSingular(), ((RainbowPublicKey)object).getCoeffScalar());
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException(exception.toString());
            }
        }
        throw new InvalidKeySpecException("Unknown key specification: " + object + ".");
    }

    public final KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof BCRainbowPrivateKey) {
            if (PKCS8EncodedKeySpec.class.isAssignableFrom(clazz)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
            if (RainbowPrivateKeySpec.class.isAssignableFrom(clazz)) {
                key = (BCRainbowPrivateKey)key;
                return new RainbowPrivateKeySpec(((BCRainbowPrivateKey)key).getInvA1(), ((BCRainbowPrivateKey)key).getB1(), ((BCRainbowPrivateKey)key).getInvA2(), ((BCRainbowPrivateKey)key).getB2(), ((BCRainbowPrivateKey)key).getVi(), ((BCRainbowPrivateKey)key).getLayers());
            }
        } else if (key instanceof BCRainbowPublicKey) {
            if (X509EncodedKeySpec.class.isAssignableFrom(clazz)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            if (RainbowPublicKeySpec.class.isAssignableFrom(clazz)) {
                key = (BCRainbowPublicKey)key;
                return new RainbowPublicKeySpec(((BCRainbowPublicKey)key).getDocLength(), ((BCRainbowPublicKey)key).getCoeffQuadratic(), ((BCRainbowPublicKey)key).getCoeffSingular(), ((BCRainbowPublicKey)key).getCoeffScalar());
            }
        } else {
            throw new InvalidKeySpecException("Unsupported key type: " + key.getClass() + ".");
        }
        throw new InvalidKeySpecException("Unknown key specification: " + clazz + ".");
    }

    public final Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof BCRainbowPrivateKey || key instanceof BCRainbowPublicKey) {
            return key;
        }
        throw new InvalidKeyException("Unsupported key type");
    }
}

