/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.sphincs;

import java.io.IOException;
import java.security.PrivateKey;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.jcajce.interfaces.SPHINCSKey;
import org.bouncycastle.util.Arrays;

public final class BCSphincs256PrivateKey
implements PrivateKey,
SPHINCSKey {
    private transient ASN1ObjectIdentifier treeDigest;
    private transient SPHINCSPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCSphincs256PrivateKey(PrivateKeyInfo object) throws IOException {
        PrivateKeyInfo privateKeyInfo = object;
        object = this;
        this.attributes = privateKeyInfo.getAttributes();
        ((BCSphincs256PrivateKey)object).treeDigest = SPHINCS256KeyParams.getInstance$789c2f4d(privateKeyInfo.getPrivateKeyAlgorithm().getParameters()).getTreeDigest().getAlgorithm();
        ((BCSphincs256PrivateKey)object).params = (SPHINCSPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSphincs256PrivateKey) {
            object = (BCSphincs256PrivateKey)object;
            if (this.treeDigest.equals(((BCSphincs256PrivateKey)object).treeDigest)) {
                byte[] byArray = this.params.getKeyData();
                byte[] byArray2 = ((BCSphincs256PrivateKey)object).params.getKeyData();
                object = byArray;
                if (java.util.Arrays.equals(byArray, byArray2)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        return ((ASN1Object)this.treeDigest).hashCode() + 37 * Arrays.hashCode(this.params.getKeyData());
    }

    public final String getAlgorithm() {
        return "SPHINCS-256";
    }

    public final byte[] getEncoded() {
        try {
            ASN1Object aSN1Object;
            if (this.params.getTreeDigest() != null) {
                aSN1Object = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            } else {
                aSN1Object = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(new AlgorithmIdentifier(this.treeDigest)));
                aSN1Object = new PrivateKeyInfo((AlgorithmIdentifier)aSN1Object, new DEROctetString(this.params.getKeyData()), this.attributes);
            }
            return aSN1Object.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final String getFormat() {
        return "PKCS#8";
    }
}

