/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.xmss;

import java.io.IOException;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import org.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;
import org.bouncycastle.util.Arrays;

public final class BCXMSSMTPublicKey
implements PublicKey {
    private transient ASN1ObjectIdentifier treeDigest;
    private transient XMSSMTPublicKeyParameters keyParams;

    public BCXMSSMTPublicKey(SubjectPublicKeyInfo object) throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = object;
        object = this;
        this.keyParams = (XMSSMTPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
        ((BCXMSSMTPublicKey)object).treeDigest = DigestUtil.getDigestOID(((BCXMSSMTPublicKey)object).keyParams.getTreeDigest());
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSMTPublicKey) {
            object = (BCXMSSMTPublicKey)object;
            if (this.treeDigest.equals(((BCXMSSMTPublicKey)object).treeDigest)) {
                byte[] byArray = this.keyParams.toByteArray();
                byte[] byArray2 = ((BCXMSSMTPublicKey)object).keyParams.toByteArray();
                object = byArray;
                if (java.util.Arrays.equals(byArray, byArray2)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        return ((ASN1Object)this.treeDigest).hashCode() + 37 * Arrays.hashCode(this.keyParams.toByteArray());
    }

    public final String getAlgorithm() {
        return "XMSSMT";
    }

    public final byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.keyParams);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final String getFormat() {
        return "X.509";
    }
}

