/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.xmss;

import java.io.IOException;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import org.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;
import org.bouncycastle.util.Arrays;

public final class BCXMSSPublicKey
implements PublicKey {
    private transient XMSSPublicKeyParameters keyParams;
    private transient ASN1ObjectIdentifier treeDigest;

    public BCXMSSPublicKey(SubjectPublicKeyInfo object) throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = object;
        object = this;
        this.keyParams = (XMSSPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
        ((BCXMSSPublicKey)object).treeDigest = DigestUtil.getDigestOID(((BCXMSSPublicKey)object).keyParams.getTreeDigest());
    }

    public final String getAlgorithm() {
        return "XMSS";
    }

    public final byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.keyParams);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final String getFormat() {
        return "X.509";
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSPublicKey) {
            object = (BCXMSSPublicKey)object;
            try {
                if (this.treeDigest.equals(((BCXMSSPublicKey)object).treeDigest)) {
                    byte[] byArray = this.keyParams.getEncoded();
                    byte[] byArray2 = ((BCXMSSPublicKey)object).keyParams.getEncoded();
                    object = byArray;
                    if (java.util.Arrays.equals(byArray, byArray2)) {
                        return true;
                    }
                }
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public final int hashCode() {
        try {
            return ((ASN1Object)this.treeDigest).hashCode() + 37 * Arrays.hashCode(this.keyParams.getEncoded());
        }
        catch (IOException iOException) {
            return ((ASN1Object)this.treeDigest).hashCode();
        }
    }
}

