/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.IntUtils;

public final class PolynomialGF2mSmallM {
    private GF2mField field;
    private int degree;
    private int[] coefficients;

    public PolynomialGF2mSmallM(GF2mField gF2mField, int n) {
        this.field = gF2mField;
        this.degree = n;
        this.coefficients = new int[n + 1];
        this.coefficients[n] = 1;
    }

    public PolynomialGF2mSmallM(GF2mField object, int[] nArray) {
        int[] nArray2;
        this.field = object;
        object = nArray;
        int n = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n == -1) {
            nArray2 = new int[1];
        } else if (((Object)object).length == n + 1) {
            nArray2 = IntUtils.clone((int[])object);
        } else {
            int[] nArray3 = new int[n + 1];
            System.arraycopy(object, 0, nArray3, 0, n + 1);
            nArray2 = nArray3;
        }
        this.coefficients = nArray2;
        this.computeDegree();
    }

    public PolynomialGF2mSmallM(GF2mField gF2mField, byte[] byArray) {
        int n;
        this.field = gF2mField;
        int n2 = 1;
        for (n = 8; gF2mField.getDegree() > n; n += 8) {
            ++n2;
        }
        if (byArray.length % n2 != 0) {
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        this.coefficients = new int[byArray.length / n2];
        n2 = 0;
        for (int i = 0; i < this.coefficients.length; ++i) {
            for (int j = 0; j < n; j += 8) {
                int n3 = i;
                this.coefficients[n3] = this.coefficients[n3] ^ (byArray[n2++] & 0xFF) << j;
            }
            if (this.field.isElementOfThisField(this.coefficients[i])) continue;
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        if (this.coefficients.length != 1 && this.coefficients[this.coefficients.length - 1] == 0) {
            throw new IllegalArgumentException(" Error: byte array is not encoded polynomial over given finite field GF2m");
        }
        this.computeDegree();
    }

    public PolynomialGF2mSmallM(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        this.field = polynomialGF2mSmallM.field;
        this.degree = polynomialGF2mSmallM.degree;
        this.coefficients = IntUtils.clone(polynomialGF2mSmallM.coefficients);
    }

    public final int getDegree() {
        int n = this.coefficients.length - 1;
        if (this.coefficients[n] == 0) {
            return -1;
        }
        return n;
    }

    private static int headCoefficient(int[] nArray) {
        int n = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n == -1) {
            return 0;
        }
        return nArray[n];
    }

    public final int getCoefficient(int n) {
        if (n < 0 || n > this.degree) {
            return 0;
        }
        return this.coefficients[n];
    }

    public final byte[] getEncoded() {
        int n;
        int n2 = 1;
        for (n = 8; this.field.getDegree() > n; n += 8) {
            ++n2;
        }
        byte[] byArray = new byte[this.coefficients.length * n2];
        n2 = 0;
        for (int i = 0; i < this.coefficients.length; ++i) {
            for (int j = 0; j < n; j += 8) {
                byArray[n2++] = (byte)(this.coefficients[i] >>> j);
            }
        }
        return byArray;
    }

    public final int evaluateAt(int n) {
        int n2 = this.coefficients[this.degree];
        for (int i = this.degree - 1; i >= 0; --i) {
            n2 = this.field.mult(n2, n) ^ this.coefficients[i];
        }
        return n2;
    }

    public final void addToThis(PolynomialGF2mSmallM polynomialGF2mSmallM) {
        this.coefficients = this.add(this.coefficients, polynomialGF2mSmallM.coefficients);
        this.computeDegree();
    }

    private int[] add(int[] nArray, int[] nArray2) {
        int[] nArray3;
        if (nArray.length < nArray2.length) {
            nArray3 = new int[nArray2.length];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
        } else {
            nArray3 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
            nArray = nArray2;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            int n2 = nArray3[i];
            nArray3[i] = n2 ^ n;
        }
        return nArray3;
    }

    public final PolynomialGF2mSmallM multWithElement(int n) {
        if (!this.field.isElementOfThisField(n)) {
            throw new ArithmeticException("Not an element of the finite field this polynomial is defined over.");
        }
        PolynomialGF2mSmallM polynomialGF2mSmallM = this;
        int[] nArray = polynomialGF2mSmallM.multWithElement(polynomialGF2mSmallM.coefficients, n);
        return new PolynomialGF2mSmallM(this.field, nArray);
    }

    public final void multThisWithElement(int n) {
        if (!this.field.isElementOfThisField(n)) {
            throw new ArithmeticException("Not an element of the finite field this polynomial is defined over.");
        }
        this.coefficients = this.multWithElement(this.coefficients, n);
        this.computeDegree();
    }

    private int[] multWithElement(int[] nArray, int n) {
        int n2 = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n2 == -1 || n == 0) {
            return new int[1];
        }
        if (n == 1) {
            return IntUtils.clone(nArray);
        }
        int[] nArray2 = new int[n2 + 1];
        while (n2 >= 0) {
            nArray2[n2] = this.field.mult(nArray[n2], n);
            --n2;
        }
        return nArray2;
    }

    public final PolynomialGF2mSmallM mod(PolynomialGF2mSmallM object) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = this;
        int[] nArray = ((PolynomialGF2mSmallM)object).coefficients;
        int[] nArray2 = polynomialGF2mSmallM.coefficients;
        object = polynomialGF2mSmallM;
        int n = PolynomialGF2mSmallM.computeDegree(nArray);
        if (n == -1) {
            throw new ArithmeticException("Division by zero");
        }
        int[] nArray3 = new int[nArray2.length];
        int n2 = PolynomialGF2mSmallM.headCoefficient(nArray);
        n2 = ((PolynomialGF2mSmallM)object).field.inverse(n2);
        System.arraycopy(nArray2, 0, nArray3, 0, nArray3.length);
        while (n <= PolynomialGF2mSmallM.computeDegree(nArray3)) {
            int[] nArray4;
            int n3 = ((PolynomialGF2mSmallM)object).field.mult(PolynomialGF2mSmallM.headCoefficient(nArray3), n2);
            int n4 = PolynomialGF2mSmallM.computeDegree(nArray3) - n;
            nArray2 = nArray;
            int n5 = PolynomialGF2mSmallM.computeDegree(nArray);
            if (n5 == -1) {
                nArray4 = new int[1];
            } else {
                int[] nArray5 = new int[n5 + n4 + 1];
                System.arraycopy(nArray2, 0, nArray5, n4, n5 + 1);
                nArray4 = nArray5;
            }
            nArray2 = nArray4;
            nArray2 = super.multWithElement(nArray2, n3);
            nArray3 = super.add(nArray2, nArray3);
        }
        object = nArray3;
        return new PolynomialGF2mSmallM(this.field, (int[])object);
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof PolynomialGF2mSmallM)) {
            return false;
        }
        object = (PolynomialGF2mSmallM)object;
        if (this.field.equals(((PolynomialGF2mSmallM)object).field) && this.degree == ((PolynomialGF2mSmallM)object).degree) {
            boolean bl;
            block6: {
                int n;
                int[] nArray = ((PolynomialGF2mSmallM)object).coefficients;
                object = this.coefficients;
                int n2 = PolynomialGF2mSmallM.computeDegree(this.coefficients);
                if (n2 != (n = PolynomialGF2mSmallM.computeDegree(nArray))) {
                    bl = false;
                } else {
                    for (n = 0; n <= n2; ++n) {
                        if (object[n] == nArray[n]) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public final int hashCode() {
        int n = this.field.hashCode();
        for (int i = 0; i < this.coefficients.length; ++i) {
            n = n * 31 + this.coefficients[i];
        }
        return n;
    }

    public final String toString() {
        String string = " Polynomial over " + this.field.toString() + ": \n";
        for (int i = 0; i < this.coefficients.length; ++i) {
            string = string + this.field.elementToStr(this.coefficients[i]) + "Y^" + i + "+";
        }
        string = string + ";";
        return string;
    }

    private void computeDegree() {
        this.degree = this.coefficients.length - 1;
        while (this.degree >= 0 && this.coefficients[this.degree] == 0) {
            --this.degree;
        }
    }

    private static int computeDegree(int[] nArray) {
        int n;
        for (n = nArray.length - 1; n >= 0 && nArray[n] == 0; --n) {
        }
        return n;
    }
}

