/*
 * Decompiled with CFR 0.152.
 */
package shaded.scala.collection;

import java.io.Serializable;
import java.util.NoSuchElementException;
import shaded.scala.Function0;
import shaded.scala.Function1;
import shaded.scala.PartialFunction;
import shaded.scala.Tuple2;
import shaded.scala.collection.AbstractIterator;
import shaded.scala.collection.IterableOnce;
import shaded.scala.collection.IterableOnceOps;
import shaded.scala.collection.Iterator$;
import shaded.scala.runtime.BoxesRunTime;
import shaded.scala.runtime.Statics;

public interface Iterator<A>
extends IterableOnce<A>,
IterableOnceOps<A, Iterator, Iterator<A>> {
    public boolean hasNext();

    public A next() throws NoSuchElementException;

    public static /* synthetic */ Iterator iterator$(Iterator $this) {
        return $this.iterator();
    }

    @Override
    default public Iterator<A> iterator() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ int indexWhere$(Iterator $this, Function1 p, int from) {
        void var2_2;
        void var1_1;
        return $this.indexWhere((Function1)var1_1, (int)var2_2);
    }

    default public int indexWhere(Function1<A, Object> p, int from) {
        int i = Math.max(from, 0);
        Iterator<A> dropped = this.drop(from);
        while (dropped.hasNext()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(dropped.next()))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static /* synthetic */ boolean isEmpty$(Iterator $this) {
        return $this.isEmpty();
    }

    @Override
    default public boolean isEmpty() {
        return !this.hasNext();
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator filter$(Iterator $this, Function1 p) {
        void var1_1;
        return $this.filter((Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public Iterator<A> filter(Function1<A, Object> p) {
        void var1_1;
        return this.filterImpl((Function1<A, Object>)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator filterImpl$(Iterator $this, Function1 p, boolean isFlipped) {
        void var2_2;
        void var1_1;
        return $this.filterImpl((Function1)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public Iterator<A> filterImpl(Function1<A, Object> p, boolean isFlipped) {
        void var2_2;
        void var1_1;
        return new AbstractIterator<A>(this, (Function1)var1_1, (boolean)var2_2){
            private A hd;
            private boolean hdDefined;
            private final /* synthetic */ Iterator $outer;
            private final Function1 p$1;
            private final boolean isFlipped$1;

            public final boolean hasNext() {
                if (!this.hdDefined) {
                    if (!this.$outer.hasNext()) {
                        return false;
                    }
                    this.hd = this.$outer.next();
                    while (BoxesRunTime.unboxToBoolean(this.p$1.apply(this.hd)) == this.isFlipped$1) {
                        if (!this.$outer.hasNext()) {
                            return false;
                        }
                        this.hd = this.$outer.next();
                    }
                    this.hdDefined = true;
                }
                return true;
            }

            public final A next() {
                if (this.hasNext()) {
                    this.hdDefined = false;
                    return this.hd;
                }
                return (A)Iterator$.scala$collection$Iterator$$_empty$1b393d2f.next();
            }
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$outer = var1_1;
                this.p$1 = var2_2;
                this.isFlipped$1 = var3_3;
                this.hdDefined = false;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator collect$(Iterator $this, PartialFunction pf) {
        void var1_1;
        return $this.collect((PartialFunction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> Iterator<B> collect(PartialFunction<A, B> pf) {
        void var1_1;
        return new Function1<A, B>(this, (PartialFunction)var1_1){
            private B hd;
            private int status;
            private final /* synthetic */ Iterator $outer;
            private final PartialFunction pf$1;

            /*
             * WARNING - void declaration
             */
            public final boolean apply$mcZD$sp(double v1) {
                void var1_1;
                return Function1.apply$mcZD$sp$(this, (double)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean apply$mcZI$sp(int v1) {
                void var1_1;
                return Function1.apply$mcZI$sp$(this, (int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final int apply$mcII$sp(int v1) {
                void var1_1;
                return Function1.apply$mcII$sp$(this, (int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final void apply$mcVI$sp(int v1) {
                void var1_1;
                Function1.apply$mcVI$sp$(this, (int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean apply$mcZJ$sp(long v1) {
                void var1_1;
                return Function1.apply$mcZJ$sp$(this, (long)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final <A$> Function1<A$, B> compose(Function1<A$, A> g) {
                void var1_1;
                return Function1.compose$(this, (Function1)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final <A$> Function1<A, A$> andThen(Function1<B, A$> g) {
                void var1_1;
                return Function1.andThen$(this, (Function1)var1_1);
            }

            public final String toString() {
                return Function1.toString$(this);
            }

            public final B apply(A value) {
                return (B)Statics.pfMarker;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean hasNext() {
                Object marker = Statics.pfMarker;
                while (this.status == 0) {
                    if (this.$outer.hasNext()) {
                        void var2_2;
                        A x = this.$outer.next();
                        B1 v = this.pf$1.applyOrElse(x, this);
                        if (marker == v) continue;
                        this.hd = var2_2;
                        this.status = 1;
                        continue;
                    }
                    this.status = -1;
                }
                return this.status == 1;
            }

            public final B next() {
                if (this.hasNext()) {
                    this.status = 0;
                    return this.hd;
                }
                return (B)Iterator$.scala$collection$Iterator$$_empty$1b393d2f.next();
            }
            {
                void var2_2;
                void var1_1;
                this.$outer = var1_1;
                this.pf$1 = var2_2;
                this.status = 0;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator map$(Iterator $this, Function1 f) {
        void var1_1;
        return $this.map((Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> Iterator<B> map(Function1<A, B> f) {
        void var1_1;
        return new AbstractIterator<B>(this, (Function1)var1_1){
            private final /* synthetic */ Iterator $outer;
            private final Function1 f$2;

            public final int knownSize() {
                return this.$outer.knownSize();
            }

            public final boolean hasNext() {
                return this.$outer.hasNext();
            }

            public final B next() {
                return (B)this.f$2.apply(this.$outer.next());
            }
            {
                void var2_2;
                void var1_1;
                this.$outer = var1_1;
                this.f$2 = var2_2;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator flatMap$(Iterator $this, Function1 f) {
        void var1_1;
        return $this.flatMap((Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> Iterator<B> flatMap(Function1<A, IterableOnce<B>> f) {
        void var1_1;
        return new AbstractIterator<B>(this, (Function1)var1_1){
            private Iterator<B> cur;
            private int _hasNext;
            private final /* synthetic */ Iterator $outer;
            private final Function1 f$3;

            public final boolean hasNext() {
                if (this._hasNext == -1) {
                    while (!this.cur.hasNext()) {
                        if (!this.$outer.hasNext()) {
                            this._hasNext = 0;
                            this.cur = Iterator$.scala$collection$Iterator$$_empty$1b393d2f;
                            return false;
                        }
                        $anon$10 var1_1 = this;
                        this.cur = Iterator$.scala$collection$Iterator$$_empty$1b393d2f;
                        var1_1.cur = ((IterableOnce)var1_1.f$3.apply(var1_1.$outer.next())).iterator();
                        var1_1._hasNext = -1;
                    }
                    this._hasNext = 1;
                    return true;
                }
                return this._hasNext == 1;
            }

            public final B next() {
                if (this.hasNext()) {
                    this._hasNext = -1;
                }
                return this.cur.next();
            }
            {
                void var2_2;
                void var1_1;
                this.$outer = var1_1;
                this.f$3 = var2_2;
                this.cur = Iterator$.scala$collection$Iterator$$_empty$1b393d2f;
                this._hasNext = -1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator concat$(Iterator $this, Function0 xs) {
        void var1_1;
        return $this.concat((Function0)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
        void var1_1;
        return ((AbstractIterator)new ConcatIterator(this)).concat(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator take$(Iterator $this, int n) {
        void var1_1;
        return $this.take((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public Iterator<A> take(int n) {
        void var1_1;
        return this.sliceIterator(0, Math.max((int)var1_1, 0));
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator takeWhile$(Iterator $this, Function1 p) {
        void var1_1;
        return $this.takeWhile((Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public Iterator<A> takeWhile(Function1<A, Object> p) {
        void var1_1;
        return new AbstractIterator<A>(this, (Function1)var1_1){
            private A hd;
            private boolean hdDefined;
            private Iterator<A> tail;
            private final Function1 p$2;

            public final boolean hasNext() {
                block6: {
                    block5: {
                        if (this.hdDefined) break block5;
                        if (!this.tail.hasNext()) break block6;
                        this.hd = this.tail.next();
                        if (BoxesRunTime.unboxToBoolean(this.p$2.apply(this.hd))) {
                            this.hdDefined = true;
                        } else {
                            this.tail = Iterator$.scala$collection$Iterator$$_empty$1b393d2f;
                        }
                        if (!this.hdDefined) break block6;
                    }
                    return true;
                }
                return false;
            }

            public final A next() {
                if (this.hasNext()) {
                    this.hdDefined = false;
                    return this.hd;
                }
                return (A)Iterator$.scala$collection$Iterator$$_empty$1b393d2f.next();
            }
            {
                void var1_1;
                void var2_2;
                this.p$2 = var2_2;
                this.hdDefined = false;
                this.tail = var1_1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator drop$(Iterator $this, int n) {
        void var1_1;
        return $this.drop((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public Iterator<A> drop(int n) {
        void var1_1;
        return this.sliceIterator((int)var1_1, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator sliceIterator$(Iterator $this, int from, int until) {
        void var2_2;
        void var1_1;
        return $this.sliceIterator((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public Iterator<A> sliceIterator(int from, int until) {
        void var2_2;
        void var1_1;
        int rest;
        int lo = Math.max(from, 0);
        if ((until < 0 ? -1 : (rest = until <= lo ? 0 : until - lo)) == 0) {
            return Iterator$.scala$collection$Iterator$$_empty$1b393d2f;
        }
        return new SliceIterator(this, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Iterator zip$(Iterator $this, IterableOnce that) {
        void var1_1;
        return $this.zip((IterableOnce)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> Iterator<Tuple2<A, B>> zip(IterableOnce<B> that) {
        void var1_1;
        return new AbstractIterator<Tuple2<A, B>>(this, (IterableOnce)var1_1){
            private final Iterator<B> thatIterator;
            private final /* synthetic */ Iterator $outer;

            /*
             * WARNING - void declaration
             */
            public final int knownSize() {
                void var2_3;
                int n = this.$outer.knownSize();
                $anon$14 var2_2 = this;
                int min$extension_that = var2_2.thatIterator.knownSize();
                return Math.min(n, (int)var2_3);
            }

            public final boolean hasNext() {
                if (this.$outer.hasNext()) {
                    $anon$14 var1_1 = this;
                    if (var1_1.thatIterator.hasNext()) {
                        return true;
                    }
                }
                return false;
            }
            {
                void var2_2;
                void var1_1;
                this.$outer = var1_1;
                this.thatIterator = var2_2.iterator();
            }
        };
    }

    public static /* synthetic */ Iterator zipWithIndex$(Iterator $this) {
        return $this.zipWithIndex();
    }

    default public Iterator<Tuple2<A, Object>> zipWithIndex() {
        return new AbstractIterator<Tuple2<A, Object>>(this){
            private int idx;
            private final /* synthetic */ Iterator $outer;

            public final int knownSize() {
                return this.$outer.knownSize();
            }

            public final boolean hasNext() {
                return this.$outer.hasNext();
            }
            {
                void var1_1;
                this.$outer = var1_1;
                this.idx = 0;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ boolean sameElements$(Iterator $this, IterableOnce that) {
        void var1_1;
        return $this.sameElements((IterableOnce)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> boolean sameElements(IterableOnce<B> that) {
        void var1_1;
        Iterator<B> those = that.iterator();
        while (this.hasNext() && those.hasNext()) {
            if (BoxesRunTime.equals(this.next(), those.next())) continue;
            return false;
        }
        return this.hasNext() == var1_1.hasNext();
    }

    public static /* synthetic */ String toString$(Iterator $this) {
        return $this.toString();
    }

    default public String toString() {
        return "<iterator>";
    }

    private static final class ConcatIterator<A>
    extends AbstractIterator<A> {
        private Iterator<A> current;
        private ConcatIteratorCell<A> tail;
        private ConcatIteratorCell<A> last;
        private boolean currentHasNextChecked;

        @Override
        public final boolean hasNext() {
            ConcatIterator concatIterator = this;
            if (concatIterator.currentHasNextChecked) {
                return true;
            }
            concatIterator = this;
            if (concatIterator.current == null) {
                return false;
            }
            concatIterator = this;
            if (concatIterator.current.hasNext()) {
                boolean bl = true;
                concatIterator = this;
                this.currentHasNextChecked = bl;
                return true;
            }
            ConcatIterator concatIterator2 = this;
            while (true) {
                concatIterator = concatIterator2;
                if (concatIterator.tail == null) {
                    Object var5_3 = null;
                    concatIterator = concatIterator2;
                    concatIterator2.current = var5_3;
                    var5_3 = null;
                    concatIterator = concatIterator2;
                    concatIterator2.last = var5_3;
                    return false;
                }
                ConcatIterator concatIterator3 = concatIterator2;
                concatIterator = concatIterator3;
                ConcatIteratorCell<A> concatIteratorCell = concatIterator3.tail.headIterator();
                concatIterator = concatIterator3;
                concatIterator3.current = concatIteratorCell;
                ConcatIterator concatIterator4 = concatIterator2;
                concatIterator = concatIterator4;
                concatIterator = concatIterator2;
                if (concatIterator4.last == concatIterator.tail) {
                    ConcatIterator concatIterator5 = concatIterator2;
                    concatIterator = concatIterator5;
                    concatIteratorCell = concatIterator5.last.tail();
                    concatIterator = concatIterator5;
                    concatIterator5.last = concatIteratorCell;
                }
                ConcatIterator concatIterator6 = concatIterator2;
                concatIterator = concatIterator6;
                concatIteratorCell = concatIterator6.tail.tail();
                concatIterator = concatIterator6;
                concatIterator6.tail = concatIteratorCell;
                ConcatIterator concatIterator7 = concatIterator2;
                while (true) {
                    ConcatIterator concatIterator8;
                    concatIterator = concatIterator7;
                    if (!(concatIterator.current instanceof ConcatIterator)) break;
                    concatIterator = concatIterator7;
                    concatIterator = concatIterator8 = (ConcatIterator)concatIterator.current;
                    Iterator<A> iterator = concatIterator.current;
                    concatIterator = concatIterator7;
                    concatIterator7.current = iterator;
                    concatIterator = concatIterator8;
                    boolean bl = concatIterator.currentHasNextChecked;
                    concatIterator = concatIterator7;
                    concatIterator7.currentHasNextChecked = bl;
                    concatIterator = concatIterator8;
                    if (concatIterator.tail == null) continue;
                    concatIterator = concatIterator7;
                    if (concatIterator.last == null) {
                        concatIterator = concatIterator8;
                        ConcatIteratorCell<A> concatIteratorCell2 = concatIterator.last;
                        concatIterator = concatIterator7;
                        concatIterator7.last = concatIteratorCell2;
                    }
                    ConcatIterator concatIterator9 = concatIterator8;
                    concatIterator = concatIterator9;
                    concatIterator = concatIterator7;
                    concatIterator9.last.tail_$eq(concatIterator.tail);
                    concatIterator = concatIterator8;
                    ConcatIteratorCell<A> concatIteratorCell3 = concatIterator.tail;
                    concatIterator = concatIterator7;
                    concatIterator7.tail = concatIteratorCell3;
                }
                concatIterator = concatIterator2;
                if (concatIterator.currentHasNextChecked) {
                    return true;
                }
                concatIterator = concatIterator2;
                if (concatIterator.current == null) continue;
                concatIterator = concatIterator2;
                if (concatIterator.current.hasNext()) break;
            }
            boolean bl = true;
            concatIterator = concatIterator2;
            concatIterator2.currentHasNextChecked = bl;
            return true;
        }

        @Override
        public final A next() {
            if (this.hasNext()) {
                boolean bl = false;
                ConcatIterator concatIterator = this;
                this.currentHasNextChecked = bl;
                concatIterator = this;
                return concatIterator.current.next();
            }
            return (A)Iterator$.scala$collection$Iterator$$_empty$1b393d2f.next();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <B> Iterator<B> concat(Function0<IterableOnce<B>> that) {
            Object object;
            ConcatIteratorCell c = new ConcatIteratorCell(that, null);
            ConcatIterator concatIterator = this;
            if (concatIterator.tail == null) {
                object = c;
                concatIterator = this;
                this.tail = object;
                object = c;
                concatIterator = this;
                this.last = object;
            } else {
                void var1_1;
                concatIterator = this;
                concatIterator.last.tail_$eq(c);
                object = var1_1;
                concatIterator = this;
                this.last = object;
            }
            concatIterator = this;
            if (concatIterator.current == null) {
                object = Iterator$.scala$collection$Iterator$$_empty$1b393d2f;
                concatIterator = this;
                this.current = object;
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public ConcatIterator(Iterator<A> current) {
            void var1_1;
            this.current = var1_1;
            this.tail = null;
            this.last = null;
            this.currentHasNextChecked = false;
        }
    }

    private static final class ConcatIteratorCell<A> {
        private final Function0<IterableOnce<A>> head;
        private ConcatIteratorCell<A> tail;

        public final ConcatIteratorCell<A> tail() {
            return this.tail;
        }

        /*
         * WARNING - void declaration
         */
        public final void tail_$eq(ConcatIteratorCell<A> x$1) {
            void var1_1;
            this.tail = var1_1;
        }

        public final Iterator<A> headIterator() {
            return this.head.apply().iterator();
        }

        /*
         * WARNING - void declaration
         */
        public ConcatIteratorCell(Function0<IterableOnce<A>> head, ConcatIteratorCell<A> tail) {
            void var1_1;
            this.head = var1_1;
            this.tail = null;
        }
    }

    public static final class SliceIterator<A>
    extends AbstractIterator<A> {
        private final Iterator<A> underlying;
        private int scala$collection$Iterator$SliceIterator$$remaining;
        private int dropping;

        private void skip() {
            while (this.dropping > 0) {
                SliceIterator sliceIterator = this;
                if (sliceIterator.underlying.hasNext()) {
                    sliceIterator = this;
                    sliceIterator.underlying.next();
                    --this.dropping;
                    continue;
                }
                this.dropping = 0;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int knownSize() {
            void var1_2;
            SliceIterator sliceIterator = this;
            int size = sliceIterator.underlying.knownSize();
            if (size < 0) {
                return -1;
            }
            int max$extension_that = size - this.dropping;
            int dropSize = Math.max(0, max$extension_that);
            if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                return dropSize;
            }
            int n = this.scala$collection$Iterator$SliceIterator$$remaining;
            return Math.min(n, (int)var1_2);
        }

        @Override
        public final boolean hasNext() {
            this.skip();
            if (this.scala$collection$Iterator$SliceIterator$$remaining != 0) {
                SliceIterator sliceIterator = this;
                if (sliceIterator.underlying.hasNext()) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public final A next() {
            this.skip();
            if (this.scala$collection$Iterator$SliceIterator$$remaining > 0) {
                --this.scala$collection$Iterator$SliceIterator$$remaining;
                SliceIterator sliceIterator = this;
                return sliceIterator.underlying.next();
            }
            if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                SliceIterator sliceIterator = this;
                return sliceIterator.underlying.next();
            }
            return (A)Iterator$.scala$collection$Iterator$$_empty$1b393d2f.next();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Iterator<A> sliceIterator(int from, int until) {
            void var2_3;
            void var1_1;
            int n;
            int lo = Math.max(from, 0);
            if (until < 0) {
                n = this.adjustedBound$1(lo);
            } else if (until <= lo) {
                n = 0;
            } else if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                n = until - lo;
            } else {
                int n2 = this.adjustedBound$1(lo);
                int min$extension_that = until - lo;
                n = Math.min(n2, min$extension_that);
            }
            int rest = n;
            int sum = this.dropping + lo;
            if (rest == 0) {
                return Iterator$.scala$collection$Iterator$$_empty$1b393d2f;
            }
            if (sum < 0) {
                void var1_2;
                this.dropping = Integer.MAX_VALUE;
                this.scala$collection$Iterator$SliceIterator$$remaining = 0;
                Function0<SliceIterator> & Serializable concat_xs = (Function0<SliceIterator> & Serializable)() -> {
                    void var2_2;
                    void var1_1;
                    SliceIterator sliceIterator;
                    return new SliceIterator(sliceIterator.underlying, (int)(var1_1 - Integer.MAX_VALUE), (int)var2_2);
                };
                return ((AbstractIterator)new ConcatIterator(this)).concat(var1_2);
            }
            this.dropping = var1_1;
            this.scala$collection$Iterator$SliceIterator$$remaining = var2_3;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private final int adjustedBound$1(int lo$1) {
            void var1_1;
            if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                return -1;
            }
            int max$extension_that = this.scala$collection$Iterator$SliceIterator$$remaining - lo$1;
            return Math.max(0, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public SliceIterator(Iterator<A> underlying, int start, int limit) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.underlying = var1_1;
            this.scala$collection$Iterator$SliceIterator$$remaining = var3_3;
            this.dropping = var2_2;
        }
    }
}

