/*
 * Decompiled with CFR 0.152.
 */
package com.dashx;

import com.dashx.DashXConfig;
import com.dashx.DashXGraphQLClient;
import com.dashx.exception.DashXConfigurationException;
import com.dashx.exception.DashXValidationException;
import com.dashx.graphql.AccountService;
import com.dashx.graphql.AssetService;
import com.dashx.graphql.EventService;
import com.dashx.graphql.IssueService;
import com.dashx.graphql.RecordService;
import com.dashx.graphql.generated.types.Account;
import com.dashx.graphql.generated.types.Asset;
import com.dashx.graphql.generated.types.CreateIssueInput;
import com.dashx.graphql.generated.types.IdentifyAccountInput;
import com.dashx.graphql.generated.types.Issue;
import com.dashx.graphql.generated.types.SearchRecordsInput;
import com.dashx.graphql.generated.types.TrackEventInput;
import com.dashx.graphql.generated.types.TrackEventResponse;
import com.dashx.graphql.generated.types.UpsertIssueInput;
import com.dashx.graphql.utils.SearchRecordsOptions;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class DashX {
    private static final Logger logger = LoggerFactory.getLogger(DashX.class);
    private static final ConcurrentHashMap<String, DashX> instances = new ConcurrentHashMap();
    private final String instanceName;
    private String baseUrl;
    private String publicKey;
    private String privateKey;
    private String targetEnvironment;
    private DashXConfig config;
    private String accountAnonymousUid;
    private String accountUid;
    private DashXGraphQLClient graphqlClient;

    private DashX(String instanceName) {
        this.instanceName = instanceName;
        this.graphqlClient = this.getGraphqlClient();
    }

    public static DashX getInstance() {
        return DashX.getInstance("default");
    }

    public static DashX getInstance(String instanceName) {
        if (!instances.containsKey(instanceName)) {
            instances.put(instanceName, new DashX(instanceName));
        }
        return instances.get(instanceName);
    }

    public void configure(DashXConfig config) {
        if (config == null) {
            throw new DashXValidationException("Configuration cannot be null");
        }
        this.init(config);
    }

    private void init(DashXConfig config) {
        this.config = config;
        this.baseUrl = config.getBaseUrl();
        this.publicKey = config.getPublicKey();
        this.privateKey = config.getPrivateKey();
        this.targetEnvironment = config.getTargetEnvironment();
        this.createGraphqlClient();
    }

    private void createGraphqlClient() {
        this.graphqlClient = this.getGraphqlClient();
    }

    private DashXGraphQLClient getGraphqlClient() {
        try {
            LinkedMultiValueMap headers = new LinkedMultiValueMap();
            if (this.publicKey != null) {
                headers.add((Object)"X-Public-Key", (Object)this.publicKey);
            }
            if (this.privateKey != null) {
                headers.add((Object)"X-Private-Key", (Object)this.privateKey);
            }
            if (this.targetEnvironment != null) {
                headers.add((Object)"X-Target-Environment", (Object)this.targetEnvironment);
            }
            return new DashXGraphQLClient(new URI(this.baseUrl != null ? this.baseUrl : "https://api.dashx.com/graphql").toURL(), (MultiValueMap<String, String>)headers, this.config);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new DashXConfigurationException("Invalid URL", e);
        }
    }

    private String generateAccountAnonymousUid() {
        return UUID.randomUUID().toString();
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public CompletableFuture<Account> identify(Map<String, Object> options) {
        String uid;
        if (options == null) {
            CompletableFuture<Account> future = new CompletableFuture<Account>();
            future.completeExceptionally(new DashXValidationException("'identify' cannot be called with null, please pass options of type 'object'."));
            return future;
        }
        String string = uid = options.containsKey("uid") ? (String)options.get("uid") : this.accountUid;
        String anonymousUid = options.containsKey("anonymousUid") ? (String)options.get("anonymousUid") : (this.accountAnonymousUid != null ? this.accountAnonymousUid : (uid == null ? this.generateAccountAnonymousUid() : null));
        AccountService accountService = new AccountService(this.graphqlClient);
        IdentifyAccountInput input = IdentifyAccountInput.newBuilder().uid(uid).anonymousUid(anonymousUid).email((String)options.get("email")).phone((String)options.get("phone")).name((String)options.get("name")).firstName((String)options.get("firstName")).lastName((String)options.get("lastName")).build();
        logger.debug("Identifying account with uid: '{}', anonymousUid: '{}'", (Object)uid, (Object)anonymousUid);
        return accountService.identifyAccount(input).toFuture();
    }

    public CompletableFuture<TrackEventResponse> track(String event, String uid, Map<String, Object> data) {
        if (event == null || event.trim().isEmpty()) {
            CompletableFuture<TrackEventResponse> future = new CompletableFuture<TrackEventResponse>();
            future.completeExceptionally(new DashXValidationException("Event name cannot be null or empty"));
            return future;
        }
        String accUid = uid != null ? uid : this.accountUid;
        String accAnonUid = this.accountAnonymousUid;
        if (accUid == null) {
            if (accAnonUid == null) {
                accAnonUid = this.generateAccountAnonymousUid();
            }
        } else {
            accAnonUid = null;
        }
        EventService eventService = new EventService(this.graphqlClient);
        TrackEventInput input = TrackEventInput.newBuilder().event(event).accountUid(accUid).accountAnonymousUid(accAnonUid).data(data).build();
        logger.debug("Tracking event '{}' for uid: '{}', anonymousUid: '{}'", new Object[]{event, accUid, accAnonUid});
        return eventService.trackEvent(input).toFuture();
    }

    public CompletableFuture<TrackEventResponse> track(String event, Map<String, Object> data) {
        return this.track(event, null, data);
    }

    public CompletableFuture<TrackEventResponse> track(String event, String uid) {
        return this.track(event, uid, null);
    }

    public CompletableFuture<TrackEventResponse> track(String event) {
        return this.track(event, null, null);
    }

    public CompletableFuture<List<Asset>> listAssets(Map<String, Object> filter, List<Map<String, Object>> order, Integer limit, Integer page) {
        AssetService assetService = new AssetService(this.graphqlClient);
        logger.debug("Listing assets with filter: {}, limit: {}, page: {}", new Object[]{filter, limit, page});
        return assetService.listAssets(filter, order, limit, page).toFuture();
    }

    public CompletableFuture<List<Asset>> listAssets(Map<String, Object> filter) {
        return this.listAssets(filter, null, null, null);
    }

    public CompletableFuture<List<Asset>> listAssets(Map<String, Object> filter, List<Map<String, Object>> order) {
        return this.listAssets(filter, order, null, null);
    }

    public CompletableFuture<List<Asset>> listAssets() {
        return this.listAssets(null, null, null, null);
    }

    public CompletableFuture<Asset> getAsset(String id) {
        if (id == null || id.trim().isEmpty()) {
            CompletableFuture<Asset> future = new CompletableFuture<Asset>();
            future.completeExceptionally(new DashXValidationException("Asset ID cannot be null or empty"));
            return future;
        }
        AssetService assetService = new AssetService(this.graphqlClient);
        logger.debug("Getting asset with id: '{}'", (Object)id);
        return assetService.getAsset(id).toFuture();
    }

    public CompletableFuture<List<Map<String, Object>>> searchRecords(String resource, SearchRecordsOptions options) {
        if (resource == null || resource.trim().isEmpty()) {
            CompletableFuture<List<Map<String, Object>>> future = new CompletableFuture<List<Map<String, Object>>>();
            future.completeExceptionally(new DashXValidationException("Resource cannot be null or empty"));
            return future;
        }
        RecordService recordService = new RecordService(this.graphqlClient);
        if (options == null) {
            options = SearchRecordsOptions.newBuilder().build();
        }
        SearchRecordsInput input = SearchRecordsInput.newBuilder().resource(resource).filter(options.getFilter()).order(options.getOrder()).limit(options.getLimit()).page(options.getPage()).preview(options.getPreview()).language(options.getLanguage()).fields(options.getFields()).include(options.getInclude()).exclude(options.getExclude()).build();
        logger.debug("Searching records for resource: '{}' with filter: {}", (Object)resource, options.getFilter());
        return recordService.searchRecords(input).toFuture();
    }

    public CompletableFuture<List<Map<String, Object>>> searchRecords(String resource) {
        return this.searchRecords(resource, null);
    }

    public CompletableFuture<Issue> createIssue(CreateIssueInput input) {
        if (input == null) {
            CompletableFuture<Issue> future = new CompletableFuture<Issue>();
            future.completeExceptionally(new DashXValidationException("CreateIssueInput cannot be null"));
            return future;
        }
        IssueService issueService = new IssueService(this.graphqlClient);
        logger.debug("Creating issue");
        return issueService.createIssue(input).toFuture();
    }

    public CompletableFuture<Issue> upsertIssue(UpsertIssueInput input) {
        if (input == null) {
            CompletableFuture<Issue> future = new CompletableFuture<Issue>();
            future.completeExceptionally(new DashXValidationException("UpsertIssueInput cannot be null"));
            return future;
        }
        IssueService issueService = new IssueService(this.graphqlClient);
        logger.debug("Upserting issue");
        return issueService.upsertIssue(input).toFuture();
    }
}

