/*
 * Decompiled with CFR 0.152.
 */
package com.dashx;

import java.util.Objects;

public final class DashXConfig {
    private final String baseUrl;
    private final String publicKey;
    private final String privateKey;
    private final String targetEnvironment;
    private final Integer connectionTimeout;
    private final Integer responseTimeout;
    private final Integer maxConnections;
    private final Integer maxIdleTime;

    private DashXConfig(Builder builder) {
        this.baseUrl = builder.baseUrl;
        this.publicKey = builder.publicKey;
        this.privateKey = builder.privateKey;
        this.targetEnvironment = builder.targetEnvironment;
        this.connectionTimeout = builder.connectionTimeout;
        this.responseTimeout = builder.responseTimeout;
        this.maxConnections = builder.maxConnections;
        this.maxIdleTime = builder.maxIdleTime;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getTargetEnvironment() {
        return this.targetEnvironment;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer getResponseTimeout() {
        return this.responseTimeout;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public Integer getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public static class Builder {
        private String baseUrl = "https://api.dashx.com/graphql";
        private String publicKey;
        private String privateKey;
        private String targetEnvironment;
        private Integer connectionTimeout = 10000;
        private Integer responseTimeout = 30000;
        private Integer maxConnections = 500;
        private Integer maxIdleTime = 20000;

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder targetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
            return this;
        }

        public Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder responseTimeout(Integer responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder maxIdleTime(Integer maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
            return this;
        }

        public DashXConfig build() {
            Objects.requireNonNull(this.publicKey, "publicKey must not be null");
            Objects.requireNonNull(this.privateKey, "privateKey must not be null");
            Objects.requireNonNull(this.targetEnvironment, "targetEnvironment must not be null");
            return new DashXConfig(this);
        }
    }
}

