/*
 * Decompiled with CFR 0.152.
 */
package com.dashx;

import com.dashx.DashXConfig;
import com.dashx.exception.DashXGraphQLException;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.MonoGraphQLClient;
import com.netflix.graphql.dgs.client.WebClientGraphQLClient;
import io.netty.channel.ChannelOption;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

public class DashXGraphQLClient {
    private final WebClientGraphQLClient webClientGraphQLClient;

    public DashXGraphQLClient(URL url, MultiValueMap<String, String> headers, DashXConfig config) {
        int connectionTimeout = config != null && config.getConnectionTimeout() != null ? config.getConnectionTimeout() : 10000;
        int responseTimeout = config != null && config.getResponseTimeout() != null ? config.getResponseTimeout() : 30000;
        int maxConnections = config != null && config.getMaxConnections() != null ? config.getMaxConnections() : 500;
        int maxIdleTime = config != null && config.getMaxIdleTime() != null ? config.getMaxIdleTime() : 20000;
        ConnectionProvider connectionProvider = ((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"dashx-pool").maxConnections(maxConnections)).maxIdleTime(Duration.ofMillis(maxIdleTime))).maxLifeTime(Duration.ofSeconds(60L))).pendingAcquireTimeout(Duration.ofSeconds(60L))).evictInBackground(Duration.ofSeconds(120L))).build();
        HttpClient httpClient = ((HttpClient)HttpClient.create((ConnectionProvider)connectionProvider).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectionTimeout)).responseTimeout(Duration.ofMillis(responseTimeout)).keepAlive(true);
        WebClient webClient = WebClient.builder().baseUrl(url.toString()).defaultHeaders(httpHeaders -> httpHeaders.addAll(headers)).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
        this.webClientGraphQLClient = MonoGraphQLClient.createWithWebClient((WebClient)webClient);
    }

    public Mono<GraphQLResponse> execute(String query, Map<String, ?> variables) {
        return this.webClientGraphQLClient.reactiveExecuteQuery(query, variables).flatMap(response -> {
            List errors = response.getErrors();
            if (errors != null && !errors.isEmpty()) {
                return Mono.error((Throwable)new DashXGraphQLException(errors));
            }
            return Mono.just((Object)response);
        });
    }
}

