/*
 * Decompiled with CFR 0.152.
 */
package com.dashx.exception;

import com.dashx.exception.DashXException;
import com.netflix.graphql.dgs.client.GraphQLError;
import java.util.List;

public class DashXGraphQLException
extends DashXException {
    private final List<GraphQLError> errors;

    public DashXGraphQLException(List<GraphQLError> errors) {
        super(DashXGraphQLException.formatErrorMessage(errors));
        this.errors = errors;
    }

    public DashXGraphQLException(String message, List<GraphQLError> errors) {
        super(message);
        this.errors = errors;
    }

    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    private static String formatErrorMessage(List<GraphQLError> errors) {
        if (errors == null || errors.isEmpty()) {
            return "GraphQL error occurred";
        }
        if (errors.size() == 1) {
            return "GraphQL error: " + errors.get(0).getMessage();
        }
        StringBuilder sb = new StringBuilder("GraphQL errors occurred:\n");
        for (int i = 0; i < errors.size(); ++i) {
            sb.append(i + 1).append(". ").append(errors.get(i).getMessage());
            if (i >= errors.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

