/*
 * Decompiled with CFR 0.152.
 */
package com.dashx.graphql;

import com.dashx.DashXGraphQLClient;
import com.dashx.graphql.generated.types.Account;
import com.dashx.graphql.generated.types.IdentifyAccountInput;
import java.util.Map;
import reactor.core.publisher.Mono;

public class AccountService {
    private final DashXGraphQLClient client;
    private final String fullAccountProjection;

    public AccountService(DashXGraphQLClient client) {
        this.client = client;
        this.fullAccountProjection = "{\n    id\n    environmentId\n    email\n    phone\n    fullName\n    name\n    firstName\n    lastName\n    avatar\n    timeZone\n    uid\n    anonymousUid\n    createdAt\n    updatedAt\n}\n";
    }

    public Mono<Account> identifyAccount(IdentifyAccountInput input) {
        String query = "mutation IdentifyAccount($input: IdentifyAccountInput!) { identifyAccount(input: $input) " + this.fullAccountProjection + " }";
        Map<String, IdentifyAccountInput> variables = Map.of("input", input);
        return this.client.execute(query, variables).map(response -> (Account)response.extractValueAsObject("identifyAccount", Account.class));
    }
}

