/*
 * Decompiled with CFR 0.152.
 */
package com.dashx.graphql;

import com.dashx.DashXGraphQLClient;
import com.dashx.graphql.generated.types.Asset;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public class AssetService {
    private final DashXGraphQLClient client;
    private final String fullAssetProjection;

    public AssetService(DashXGraphQLClient client) {
        this.client = client;
        this.fullAssetProjection = "{\n    id\n    workspaceId\n    resourceId\n    attributeId\n    storageProviderId\n    uploaderId\n    data\n    uploadStatus\n    processingStatus\n    name\n    size\n    mimeType\n    uploadStatusReason\n    processingStatusReason\n    url\n    staticVideoUrls\n    staticAudioUrl\n    createdAt\n    updatedAt\n}\n";
    }

    public Mono<Asset> getAsset(String id) {
        String query = "query GetAsset($id: String!) { asset(id: $id) " + this.fullAssetProjection + " }";
        Map<String, String> variables = Map.of("id", id);
        return this.client.execute(query, variables).map(response -> (Asset)response.extractValueAsObject("asset", Asset.class));
    }

    public Mono<List<Asset>> listAssets(Map<String, Object> filter, List<Map<String, Object>> order, Integer limit, Integer page) {
        String query = "query ListAssets($filter: JSON, $order: [JSON], $limit: Int, $page: Int) { assetsList(filter: $filter, order: $order, limit: $limit, page: $page) " + this.fullAssetProjection + " }";
        Map<String, Integer> variables = Map.of("filter", filter, "order", order, "limit", limit, "page", page);
        return this.client.execute(query, variables).map(response -> {
            Asset[] assetsArray = (Asset[])response.extractValueAsObject("assetsList", Asset[].class);
            return assetsArray != null ? List.of(assetsArray) : List.of();
        });
    }
}

