/*
 * Decompiled with CFR 0.152.
 */
package com.dashx.graphql;

import com.dashx.DashXGraphQLClient;
import com.dashx.graphql.generated.types.CreateIssueInput;
import com.dashx.graphql.generated.types.Issue;
import com.dashx.graphql.generated.types.UpsertIssueInput;
import java.util.Map;
import reactor.core.publisher.Mono;

public class IssueService {
    private final DashXGraphQLClient client;
    private final String fullIssueProjection;

    public IssueService(DashXGraphQLClient client) {
        this.client = client;
        this.fullIssueProjection = "{\n    id\n    workspaceId\n    issueStatusId\n    createdById\n    environmentId\n    spaceId\n    parentId\n    assigneeId\n    groupId\n    title\n    description\n    position\n    properties\n    createdAt\n    updatedAt\n    issueTypeId\n    dueAt\n    number\n    idempotencyKey\n    priority\n}\n";
    }

    public Mono<Issue> createIssue(CreateIssueInput input) {
        String query = "mutation CreateIssue($input: CreateIssueInput!) { createIssue(input: $input) " + this.fullIssueProjection + " }";
        Map<String, CreateIssueInput> variables = Map.of("input", input);
        return this.client.execute(query, variables).map(response -> (Issue)response.extractValueAsObject("createIssue", Issue.class));
    }

    public Mono<Issue> upsertIssue(UpsertIssueInput input) {
        String query = "mutation UpsertIssue($input: UpsertIssueInput!) { upsertIssue(input: $input) " + this.fullIssueProjection + " }";
        Map<String, UpsertIssueInput> variables = Map.of("input", input);
        return this.client.execute(query, variables).map(response -> (Issue)response.extractValueAsObject("upsertIssue", Issue.class));
    }
}

