/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.ConfigLoader;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.service.billing.BillableUsageAPI;
import com.databricks.sdk.service.billing.BillableUsageService;
import com.databricks.sdk.service.billing.BudgetsAPI;
import com.databricks.sdk.service.billing.BudgetsService;
import com.databricks.sdk.service.billing.LogDeliveryAPI;
import com.databricks.sdk.service.billing.LogDeliveryService;
import com.databricks.sdk.service.catalog.AccountMetastoreAssignmentsAPI;
import com.databricks.sdk.service.catalog.AccountMetastoreAssignmentsService;
import com.databricks.sdk.service.catalog.AccountMetastoresAPI;
import com.databricks.sdk.service.catalog.AccountMetastoresService;
import com.databricks.sdk.service.catalog.AccountStorageCredentialsAPI;
import com.databricks.sdk.service.catalog.AccountStorageCredentialsService;
import com.databricks.sdk.service.iam.AccountGroupsAPI;
import com.databricks.sdk.service.iam.AccountGroupsService;
import com.databricks.sdk.service.iam.AccountServicePrincipalsAPI;
import com.databricks.sdk.service.iam.AccountServicePrincipalsService;
import com.databricks.sdk.service.iam.AccountUsersAPI;
import com.databricks.sdk.service.iam.AccountUsersService;
import com.databricks.sdk.service.iam.WorkspaceAssignmentAPI;
import com.databricks.sdk.service.iam.WorkspaceAssignmentService;
import com.databricks.sdk.service.oauth2.CustomAppIntegrationAPI;
import com.databricks.sdk.service.oauth2.CustomAppIntegrationService;
import com.databricks.sdk.service.oauth2.OAuthEnrollmentAPI;
import com.databricks.sdk.service.oauth2.OAuthEnrollmentService;
import com.databricks.sdk.service.oauth2.PublishedAppIntegrationAPI;
import com.databricks.sdk.service.oauth2.PublishedAppIntegrationService;
import com.databricks.sdk.service.provisioning.CredentialsAPI;
import com.databricks.sdk.service.provisioning.CredentialsService;
import com.databricks.sdk.service.provisioning.EncryptionKeysAPI;
import com.databricks.sdk.service.provisioning.EncryptionKeysService;
import com.databricks.sdk.service.provisioning.NetworksAPI;
import com.databricks.sdk.service.provisioning.NetworksService;
import com.databricks.sdk.service.provisioning.PrivateAccessAPI;
import com.databricks.sdk.service.provisioning.PrivateAccessService;
import com.databricks.sdk.service.provisioning.StorageAPI;
import com.databricks.sdk.service.provisioning.StorageService;
import com.databricks.sdk.service.provisioning.VpcEndpointsAPI;
import com.databricks.sdk.service.provisioning.VpcEndpointsService;
import com.databricks.sdk.service.provisioning.WorkspacesAPI;
import com.databricks.sdk.service.provisioning.WorkspacesService;
import com.databricks.sdk.service.settings.AccountIpAccessListsAPI;
import com.databricks.sdk.service.settings.AccountIpAccessListsService;
import com.databricks.sdk.support.Generated;

@Generated
public class AccountClient {
    private final ApiClient apiClient;
    private final DatabricksConfig config;
    private BillableUsageAPI billableUsageAPI;
    private BudgetsAPI budgetsAPI;
    private CredentialsAPI credentialsAPI;
    private CustomAppIntegrationAPI customAppIntegrationAPI;
    private EncryptionKeysAPI encryptionKeysAPI;
    private AccountGroupsAPI groupsAPI;
    private AccountIpAccessListsAPI ipAccessListsAPI;
    private LogDeliveryAPI logDeliveryAPI;
    private AccountMetastoreAssignmentsAPI metastoreAssignmentsAPI;
    private AccountMetastoresAPI metastoresAPI;
    private NetworksAPI networksAPI;
    private OAuthEnrollmentAPI oAuthEnrollmentAPI;
    private PrivateAccessAPI privateAccessAPI;
    private PublishedAppIntegrationAPI publishedAppIntegrationAPI;
    private AccountServicePrincipalsAPI servicePrincipalsAPI;
    private StorageAPI storageAPI;
    private AccountStorageCredentialsAPI storageCredentialsAPI;
    private AccountUsersAPI usersAPI;
    private VpcEndpointsAPI vpcEndpointsAPI;
    private WorkspaceAssignmentAPI workspaceAssignmentAPI;
    private WorkspacesAPI workspacesAPI;

    public AccountClient() {
        this(ConfigLoader.getDefault());
    }

    public AccountClient(DatabricksConfig config) {
        this.config = config;
        this.apiClient = new ApiClient(config);
        this.billableUsageAPI = new BillableUsageAPI(this.apiClient);
        this.budgetsAPI = new BudgetsAPI(this.apiClient);
        this.credentialsAPI = new CredentialsAPI(this.apiClient);
        this.customAppIntegrationAPI = new CustomAppIntegrationAPI(this.apiClient);
        this.encryptionKeysAPI = new EncryptionKeysAPI(this.apiClient);
        this.groupsAPI = new AccountGroupsAPI(this.apiClient);
        this.ipAccessListsAPI = new AccountIpAccessListsAPI(this.apiClient);
        this.logDeliveryAPI = new LogDeliveryAPI(this.apiClient);
        this.metastoreAssignmentsAPI = new AccountMetastoreAssignmentsAPI(this.apiClient);
        this.metastoresAPI = new AccountMetastoresAPI(this.apiClient);
        this.networksAPI = new NetworksAPI(this.apiClient);
        this.oAuthEnrollmentAPI = new OAuthEnrollmentAPI(this.apiClient);
        this.privateAccessAPI = new PrivateAccessAPI(this.apiClient);
        this.publishedAppIntegrationAPI = new PublishedAppIntegrationAPI(this.apiClient);
        this.servicePrincipalsAPI = new AccountServicePrincipalsAPI(this.apiClient);
        this.storageAPI = new StorageAPI(this.apiClient);
        this.storageCredentialsAPI = new AccountStorageCredentialsAPI(this.apiClient);
        this.usersAPI = new AccountUsersAPI(this.apiClient);
        this.vpcEndpointsAPI = new VpcEndpointsAPI(this.apiClient);
        this.workspaceAssignmentAPI = new WorkspaceAssignmentAPI(this.apiClient);
        this.workspacesAPI = new WorkspacesAPI(this.apiClient);
    }

    public AccountClient(boolean mock) {
        this.apiClient = null;
        this.config = null;
    }

    public BillableUsageAPI billableUsage() {
        return this.billableUsageAPI;
    }

    public BudgetsAPI budgets() {
        return this.budgetsAPI;
    }

    public CredentialsAPI credentials() {
        return this.credentialsAPI;
    }

    public CustomAppIntegrationAPI customAppIntegration() {
        return this.customAppIntegrationAPI;
    }

    public EncryptionKeysAPI encryptionKeys() {
        return this.encryptionKeysAPI;
    }

    public AccountGroupsAPI groups() {
        return this.groupsAPI;
    }

    public AccountIpAccessListsAPI ipAccessLists() {
        return this.ipAccessListsAPI;
    }

    public LogDeliveryAPI logDelivery() {
        return this.logDeliveryAPI;
    }

    public AccountMetastoreAssignmentsAPI metastoreAssignments() {
        return this.metastoreAssignmentsAPI;
    }

    public AccountMetastoresAPI metastores() {
        return this.metastoresAPI;
    }

    public NetworksAPI networks() {
        return this.networksAPI;
    }

    public OAuthEnrollmentAPI oAuthEnrollment() {
        return this.oAuthEnrollmentAPI;
    }

    public PrivateAccessAPI privateAccess() {
        return this.privateAccessAPI;
    }

    public PublishedAppIntegrationAPI publishedAppIntegration() {
        return this.publishedAppIntegrationAPI;
    }

    public AccountServicePrincipalsAPI servicePrincipals() {
        return this.servicePrincipalsAPI;
    }

    public StorageAPI storage() {
        return this.storageAPI;
    }

    public AccountStorageCredentialsAPI storageCredentials() {
        return this.storageCredentialsAPI;
    }

    public AccountUsersAPI users() {
        return this.usersAPI;
    }

    public VpcEndpointsAPI vpcEndpoints() {
        return this.vpcEndpointsAPI;
    }

    public WorkspaceAssignmentAPI workspaceAssignment() {
        return this.workspaceAssignmentAPI;
    }

    public WorkspacesAPI workspaces() {
        return this.workspacesAPI;
    }

    public AccountClient withBillableUsageImpl(BillableUsageService billableUsage) {
        this.billableUsageAPI = new BillableUsageAPI(billableUsage);
        return this;
    }

    public AccountClient withBudgetsImpl(BudgetsService budgets) {
        this.budgetsAPI = new BudgetsAPI(budgets);
        return this;
    }

    public AccountClient withCredentialsImpl(CredentialsService credentials) {
        this.credentialsAPI = new CredentialsAPI(credentials);
        return this;
    }

    public AccountClient withCustomAppIntegrationImpl(CustomAppIntegrationService customAppIntegration) {
        this.customAppIntegrationAPI = new CustomAppIntegrationAPI(customAppIntegration);
        return this;
    }

    public AccountClient withEncryptionKeysImpl(EncryptionKeysService encryptionKeys) {
        this.encryptionKeysAPI = new EncryptionKeysAPI(encryptionKeys);
        return this;
    }

    public AccountClient withGroupsImpl(AccountGroupsService accountGroups) {
        this.groupsAPI = new AccountGroupsAPI(accountGroups);
        return this;
    }

    public AccountClient withIpAccessListsImpl(AccountIpAccessListsService accountIpAccessLists) {
        this.ipAccessListsAPI = new AccountIpAccessListsAPI(accountIpAccessLists);
        return this;
    }

    public AccountClient withLogDeliveryImpl(LogDeliveryService logDelivery) {
        this.logDeliveryAPI = new LogDeliveryAPI(logDelivery);
        return this;
    }

    public AccountClient withMetastoreAssignmentsImpl(AccountMetastoreAssignmentsService accountMetastoreAssignments) {
        this.metastoreAssignmentsAPI = new AccountMetastoreAssignmentsAPI(accountMetastoreAssignments);
        return this;
    }

    public AccountClient withMetastoresImpl(AccountMetastoresService accountMetastores) {
        this.metastoresAPI = new AccountMetastoresAPI(accountMetastores);
        return this;
    }

    public AccountClient withNetworksImpl(NetworksService networks) {
        this.networksAPI = new NetworksAPI(networks);
        return this;
    }

    public AccountClient withOAuthEnrollmentImpl(OAuthEnrollmentService oAuthEnrollment) {
        this.oAuthEnrollmentAPI = new OAuthEnrollmentAPI(oAuthEnrollment);
        return this;
    }

    public AccountClient withPrivateAccessImpl(PrivateAccessService privateAccess) {
        this.privateAccessAPI = new PrivateAccessAPI(privateAccess);
        return this;
    }

    public AccountClient withPublishedAppIntegrationImpl(PublishedAppIntegrationService publishedAppIntegration) {
        this.publishedAppIntegrationAPI = new PublishedAppIntegrationAPI(publishedAppIntegration);
        return this;
    }

    public AccountClient withServicePrincipalsImpl(AccountServicePrincipalsService accountServicePrincipals) {
        this.servicePrincipalsAPI = new AccountServicePrincipalsAPI(accountServicePrincipals);
        return this;
    }

    public AccountClient withStorageImpl(StorageService storage) {
        this.storageAPI = new StorageAPI(storage);
        return this;
    }

    public AccountClient withStorageCredentialsImpl(AccountStorageCredentialsService accountStorageCredentials) {
        this.storageCredentialsAPI = new AccountStorageCredentialsAPI(accountStorageCredentials);
        return this;
    }

    public AccountClient withUsersImpl(AccountUsersService accountUsers) {
        this.usersAPI = new AccountUsersAPI(accountUsers);
        return this;
    }

    public AccountClient withVpcEndpointsImpl(VpcEndpointsService vpcEndpoints) {
        this.vpcEndpointsAPI = new VpcEndpointsAPI(vpcEndpoints);
        return this;
    }

    public AccountClient withWorkspaceAssignmentImpl(WorkspaceAssignmentService workspaceAssignment) {
        this.workspaceAssignmentAPI = new WorkspaceAssignmentAPI(workspaceAssignment);
        return this;
    }

    public AccountClient withWorkspacesImpl(WorkspacesService workspaces) {
        this.workspacesAPI = new WorkspacesAPI(workspaces);
        return this;
    }

    public ApiClient apiClient() {
        return this.apiClient;
    }

    public DatabricksConfig config() {
        return this.config;
    }
}

