/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SimpleHttpServer
implements Runnable {
    private final ServerSocket server;
    private final Handler handler;
    private volatile boolean running;
    private Thread thread;

    public SimpleHttpServer(Handler handler) throws IOException {
        this(0, handler);
    }

    public SimpleHttpServer(int port, Handler handler) throws IOException {
        this.handler = handler;
        this.server = new ServerSocket(port);
    }

    public String getUrl() {
        return String.format("http://localhost:%d", this.server.getLocalPort());
    }

    public void accept() throws IOException {
        Socket clientSocket = this.server.accept();
        BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
        PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
        this.handler.accept(in, out);
        out.flush();
        out.close();
    }

    public void start() throws InterruptedException {
        this.running = true;
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.setName(String.format("SimpleHttpServer<%s>", this.getUrl()));
        this.thread.start();
    }

    public synchronized void stop() {
        this.running = false;
        this.thread.interrupt();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.accept();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Map<String, String> query(String line) {
        String regex = "(\\\\?|&)(\\w+)=(.*?)(?:&|\\s|$)";
        Pattern pattern = Pattern.compile("(\\\\?|&)(\\w+)=(.*?)(?:&|\\s|$)", 8);
        Matcher matcher = pattern.matcher(line);
        HashMap<String, String> query = new HashMap<String, String>();
        while (matcher.find()) {
            try {
                String raw = matcher.group(3);
                String decoded = URLDecoder.decode(raw, "UTF-8");
                query.put(matcher.group(2), decoded);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return query;
    }

    public static void main(String[] args) throws IOException {
        SimpleHttpServer srv = new SimpleHttpServer(8001, (in, out) -> {
            String firstLine = in.readLine();
            Map<String, String> query = SimpleHttpServer.query(firstLine);
            out.println("HTTP/1.1 200 OK");
            out.println("Connection: close");
            out.println("Content-Type: text/plain");
            out.println();
            out.println(firstLine);
        });
        System.out.println(srv.getUrl());
        srv.running = true;
        srv.run();
    }

    public static interface Handler {
        public void accept(BufferedReader var1, PrintWriter var2) throws IOException;
    }
}

