/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;

public class Token {
    @JsonProperty
    private String accessToken;
    @JsonProperty
    private String tokenType;
    @JsonProperty
    private String refreshToken;
    @JsonProperty
    private LocalDateTime expiry;

    public Token(String accessToken, String tokenType, LocalDateTime expiry) {
        this(accessToken, tokenType, null, expiry);
    }

    public Token(String accessToken, String tokenType, String refreshToken, LocalDateTime expiry) {
        Objects.requireNonNull(accessToken, "accessToken must be defined");
        Objects.requireNonNull(tokenType, "tokenType must be defined");
        Objects.requireNonNull(expiry, "expiry must be defined");
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.refreshToken = refreshToken;
        this.expiry = expiry;
    }

    public boolean isExpired() {
        if (this.expiry == null) {
            return false;
        }
        LocalDateTime potentiallyExpired = this.expiry.minus(10L, ChronoUnit.SECONDS);
        LocalDateTime now = LocalDateTime.now();
        return potentiallyExpired.isBefore(now);
    }

    public boolean isValid() {
        return this.accessToken != null && !this.isExpired();
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }
}

