/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.AccountMetastoresService;
import com.databricks.sdk.service.catalog.CreateMetastore;
import com.databricks.sdk.service.catalog.DeleteAccountMetastoreRequest;
import com.databricks.sdk.service.catalog.GetAccountMetastoreRequest;
import com.databricks.sdk.service.catalog.ListMetastoresResponse;
import com.databricks.sdk.service.catalog.MetastoreInfo;
import com.databricks.sdk.service.catalog.UpdateMetastore;
import com.databricks.sdk.support.Generated;

@Generated
class AccountMetastoresImpl
implements AccountMetastoresService {
    private final ApiClient apiClient;

    public AccountMetastoresImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public MetastoreInfo create(CreateMetastore request) {
        String path = String.format("/api/2.0/accounts/%s/metastores", this.apiClient.configuredAccountID());
        return this.apiClient.POST(path, request, MetastoreInfo.class);
    }

    @Override
    public void delete(DeleteAccountMetastoreRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getMetastoreId());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public MetastoreInfo get(GetAccountMetastoreRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getMetastoreId());
        return this.apiClient.GET(path, request, MetastoreInfo.class);
    }

    @Override
    public ListMetastoresResponse list() {
        String path = String.format("/api/2.0/accounts/%s/metastores", this.apiClient.configuredAccountID());
        return this.apiClient.GET(path, ListMetastoresResponse.class);
    }

    @Override
    public MetastoreInfo update(UpdateMetastore request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getMetastoreId());
        return this.apiClient.PUT(path, request, MetastoreInfo.class);
    }
}

