/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateMetastore;
import com.databricks.sdk.service.catalog.CreateMetastoreAssignment;
import com.databricks.sdk.service.catalog.DeleteMetastoreRequest;
import com.databricks.sdk.service.catalog.GetMetastoreRequest;
import com.databricks.sdk.service.catalog.GetMetastoreSummaryResponse;
import com.databricks.sdk.service.catalog.MetastoreAssignment;
import com.databricks.sdk.service.catalog.MetastoreInfo;
import com.databricks.sdk.service.catalog.MetastoresImpl;
import com.databricks.sdk.service.catalog.MetastoresService;
import com.databricks.sdk.service.catalog.UnassignRequest;
import com.databricks.sdk.service.catalog.UpdateAutoMaintenance;
import com.databricks.sdk.service.catalog.UpdateAutoMaintenanceResponse;
import com.databricks.sdk.service.catalog.UpdateMetastore;
import com.databricks.sdk.service.catalog.UpdateMetastoreAssignment;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class MetastoresAPI {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoresAPI.class);
    private final MetastoresService impl;

    public MetastoresAPI(ApiClient apiClient) {
        this.impl = new MetastoresImpl(apiClient);
    }

    public MetastoresAPI(MetastoresService mock) {
        this.impl = mock;
    }

    public void assign(String metastoreId, String defaultCatalogName, long workspaceId) {
        this.assign(new CreateMetastoreAssignment().setMetastoreId(metastoreId).setDefaultCatalogName(defaultCatalogName).setWorkspaceId(workspaceId));
    }

    public void assign(CreateMetastoreAssignment request) {
        this.impl.assign(request);
    }

    public MetastoreInfo create(String name, String storageRoot) {
        return this.create(new CreateMetastore().setName(name).setStorageRoot(storageRoot));
    }

    public MetastoreInfo create(CreateMetastore request) {
        return this.impl.create(request);
    }

    public MetastoreAssignment current() {
        return this.impl.current();
    }

    public void delete(String id) {
        this.delete(new DeleteMetastoreRequest().setId(id));
    }

    public void delete(DeleteMetastoreRequest request) {
        this.impl.delete(request);
    }

    public MetastoreInfo get(String id) {
        return this.get(new GetMetastoreRequest().setId(id));
    }

    public MetastoreInfo get(GetMetastoreRequest request) {
        return this.impl.get(request);
    }

    public Iterable<MetastoreInfo> list() {
        return this.impl.list().getMetastores();
    }

    public UpdateAutoMaintenanceResponse maintenance(String metastoreId, boolean enable) {
        return this.maintenance(new UpdateAutoMaintenance().setMetastoreId(metastoreId).setEnable(enable));
    }

    public UpdateAutoMaintenanceResponse maintenance(UpdateAutoMaintenance request) {
        return this.impl.maintenance(request);
    }

    public GetMetastoreSummaryResponse summary() {
        return this.impl.summary();
    }

    public void unassign(long workspaceId, String metastoreId) {
        this.unassign(new UnassignRequest().setWorkspaceId(workspaceId).setMetastoreId(metastoreId));
    }

    public void unassign(UnassignRequest request) {
        this.impl.unassign(request);
    }

    public MetastoreInfo update(String metastoreId, String id) {
        return this.update(new UpdateMetastore().setMetastoreId(metastoreId).setId(id));
    }

    public MetastoreInfo update(UpdateMetastore request) {
        return this.impl.update(request);
    }

    public void updateAssignment(long workspaceId, String metastoreId) {
        this.updateAssignment(new UpdateMetastoreAssignment().setWorkspaceId(workspaceId).setMetastoreId(metastoreId));
    }

    public void updateAssignment(UpdateMetastoreAssignment request) {
        this.impl.updateAssignment(request);
    }

    public MetastoresService impl() {
        return this.impl;
    }
}

