/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iam;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.iam.DeleteGroupRequest;
import com.databricks.sdk.service.iam.GetGroupRequest;
import com.databricks.sdk.service.iam.Group;
import com.databricks.sdk.service.iam.GroupsImpl;
import com.databricks.sdk.service.iam.GroupsService;
import com.databricks.sdk.service.iam.ListGroupsRequest;
import com.databricks.sdk.service.iam.PartialUpdate;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class GroupsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(GroupsAPI.class);
    private final GroupsService impl;

    public GroupsAPI(ApiClient apiClient) {
        this.impl = new GroupsImpl(apiClient);
    }

    public GroupsAPI(GroupsService mock) {
        this.impl = mock;
    }

    public Group create(String id) {
        return this.create(new Group().setId(id));
    }

    public Group create(Group request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteGroupRequest().setId(id));
    }

    public void delete(DeleteGroupRequest request) {
        this.impl.delete(request);
    }

    public Group get(String id) {
        return this.get(new GetGroupRequest().setId(id));
    }

    public Group get(GetGroupRequest request) {
        return this.impl.get(request);
    }

    public Iterable<Group> list(ListGroupsRequest request) {
        return this.impl.list(request).getResources();
    }

    public void patch(String id) {
        this.patch(new PartialUpdate().setId(id));
    }

    public void patch(PartialUpdate request) {
        this.impl.patch(request);
    }

    public void update(String id) {
        this.update(new Group().setId(id));
    }

    public void update(Group request) {
        this.impl.update(request);
    }

    public GroupsService impl() {
        return this.impl;
    }
}

