/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iam;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.iam.DeleteWorkspaceAssignmentRequest;
import com.databricks.sdk.service.iam.GetWorkspaceAssignmentRequest;
import com.databricks.sdk.service.iam.ListWorkspaceAssignmentRequest;
import com.databricks.sdk.service.iam.PermissionAssignment;
import com.databricks.sdk.service.iam.UpdateWorkspaceAssignments;
import com.databricks.sdk.service.iam.WorkspaceAssignmentImpl;
import com.databricks.sdk.service.iam.WorkspaceAssignmentService;
import com.databricks.sdk.service.iam.WorkspacePermission;
import com.databricks.sdk.service.iam.WorkspacePermissions;
import com.databricks.sdk.support.Generated;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class WorkspaceAssignmentAPI {
    private static final Logger LOG = LoggerFactory.getLogger(WorkspaceAssignmentAPI.class);
    private final WorkspaceAssignmentService impl;

    public WorkspaceAssignmentAPI(ApiClient apiClient) {
        this.impl = new WorkspaceAssignmentImpl(apiClient);
    }

    public WorkspaceAssignmentAPI(WorkspaceAssignmentService mock) {
        this.impl = mock;
    }

    public void delete(long workspaceId, long principalId) {
        this.delete(new DeleteWorkspaceAssignmentRequest().setWorkspaceId(workspaceId).setPrincipalId(principalId));
    }

    public void delete(DeleteWorkspaceAssignmentRequest request) {
        this.impl.delete(request);
    }

    public WorkspacePermissions get(long workspaceId) {
        return this.get(new GetWorkspaceAssignmentRequest().setWorkspaceId(workspaceId));
    }

    public WorkspacePermissions get(GetWorkspaceAssignmentRequest request) {
        return this.impl.get(request);
    }

    public Iterable<PermissionAssignment> list(long workspaceId) {
        return this.list(new ListWorkspaceAssignmentRequest().setWorkspaceId(workspaceId));
    }

    public Iterable<PermissionAssignment> list(ListWorkspaceAssignmentRequest request) {
        return this.impl.list(request).getPermissionAssignments();
    }

    public void update(Collection<WorkspacePermission> permissions, long workspaceId, long principalId) {
        this.update(new UpdateWorkspaceAssignments().setPermissions(permissions).setWorkspaceId(workspaceId).setPrincipalId(principalId));
    }

    public void update(UpdateWorkspaceAssignments request) {
        this.impl.update(request);
    }

    public WorkspaceAssignmentService impl() {
        return this.impl;
    }
}

