/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.workspace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.workspace.Delete;
import com.databricks.sdk.service.workspace.ExportRequest;
import com.databricks.sdk.service.workspace.ExportResponse;
import com.databricks.sdk.service.workspace.GetStatusRequest;
import com.databricks.sdk.service.workspace.Import;
import com.databricks.sdk.service.workspace.ListWorkspaceRequest;
import com.databricks.sdk.service.workspace.Mkdirs;
import com.databricks.sdk.service.workspace.ObjectInfo;
import com.databricks.sdk.service.workspace.WorkspaceImpl;
import com.databricks.sdk.service.workspace.WorkspaceService;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class WorkspaceAPI {
    private static final Logger LOG = LoggerFactory.getLogger(WorkspaceAPI.class);
    private final WorkspaceService impl;

    public WorkspaceAPI(ApiClient apiClient) {
        this.impl = new WorkspaceImpl(apiClient);
    }

    public WorkspaceAPI(WorkspaceService mock) {
        this.impl = mock;
    }

    public void delete(String path) {
        this.delete(new Delete().setPath(path));
    }

    public void delete(Delete request) {
        this.impl.delete(request);
    }

    public ExportResponse export(String path) {
        return this.export(new ExportRequest().setPath(path));
    }

    public ExportResponse export(ExportRequest request) {
        return this.impl.export(request);
    }

    public ObjectInfo getStatus(String path) {
        return this.getStatus(new GetStatusRequest().setPath(path));
    }

    public ObjectInfo getStatus(GetStatusRequest request) {
        return this.impl.getStatus(request);
    }

    public void importContent(String path) {
        this.importContent(new Import().setPath(path));
    }

    public void importContent(Import request) {
        this.impl.importContent(request);
    }

    public Iterable<ObjectInfo> list(String path) {
        return this.list(new ListWorkspaceRequest().setPath(path));
    }

    public Iterable<ObjectInfo> list(ListWorkspaceRequest request) {
        return this.impl.list(request).getObjects();
    }

    public void mkdirs(String path) {
        this.mkdirs(new Mkdirs().setPath(path));
    }

    public void mkdirs(Mkdirs request) {
        this.impl.mkdirs(request);
    }

    public WorkspaceService impl() {
        return this.impl;
    }
}

