/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.compute;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.compute.ClusterStatusRequest;
import com.databricks.sdk.service.compute.InstallLibraries;
import com.databricks.sdk.service.compute.LibrariesImpl;
import com.databricks.sdk.service.compute.LibrariesService;
import com.databricks.sdk.service.compute.Library;
import com.databricks.sdk.service.compute.LibraryFullStatus;
import com.databricks.sdk.service.compute.ListAllClusterLibraryStatusesResponse;
import com.databricks.sdk.service.compute.UninstallLibraries;
import com.databricks.sdk.support.Generated;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class LibrariesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(LibrariesAPI.class);
    private final LibrariesService impl;

    public LibrariesAPI(ApiClient apiClient) {
        this.impl = new LibrariesImpl(apiClient);
    }

    public LibrariesAPI(LibrariesService mock) {
        this.impl = mock;
    }

    public ListAllClusterLibraryStatusesResponse allClusterStatuses() {
        return this.impl.allClusterStatuses();
    }

    public Iterable<LibraryFullStatus> clusterStatus(String clusterId) {
        return this.clusterStatus(new ClusterStatusRequest().setClusterId(clusterId));
    }

    public Iterable<LibraryFullStatus> clusterStatus(ClusterStatusRequest request) {
        return this.impl.clusterStatus(request).getLibraryStatuses();
    }

    public void install(String clusterId, Collection<Library> libraries) {
        this.install(new InstallLibraries().setClusterId(clusterId).setLibraries(libraries));
    }

    public void install(InstallLibraries request) {
        this.impl.install(request);
    }

    public void uninstall(String clusterId, Collection<Library> libraries) {
        this.uninstall(new UninstallLibraries().setClusterId(clusterId).setLibraries(libraries));
    }

    public void uninstall(UninstallLibraries request) {
        this.impl.uninstall(request);
    }

    public LibrariesService impl() {
        return this.impl;
    }
}

