/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateSchema;
import com.databricks.sdk.service.catalog.DeleteSchemaRequest;
import com.databricks.sdk.service.catalog.GetSchemaRequest;
import com.databricks.sdk.service.catalog.ListSchemasRequest;
import com.databricks.sdk.service.catalog.ListSchemasResponse;
import com.databricks.sdk.service.catalog.SchemaInfo;
import com.databricks.sdk.service.catalog.SchemasService;
import com.databricks.sdk.service.catalog.UpdateSchema;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class SchemasImpl
implements SchemasService {
    private final ApiClient apiClient;

    public SchemasImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public SchemaInfo create(CreateSchema request) {
        String path = "/api/2.1/unity-catalog/schemas";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, SchemaInfo.class, headers);
    }

    @Override
    public void delete(DeleteSchemaRequest request) {
        String path = String.format("/api/2.1/unity-catalog/schemas/%s", request.getFullName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public SchemaInfo get(GetSchemaRequest request) {
        String path = String.format("/api/2.1/unity-catalog/schemas/%s", request.getFullName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, SchemaInfo.class, headers);
    }

    @Override
    public ListSchemasResponse list(ListSchemasRequest request) {
        String path = "/api/2.1/unity-catalog/schemas";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListSchemasResponse.class, headers);
    }

    @Override
    public SchemaInfo update(UpdateSchema request) {
        String path = String.format("/api/2.1/unity-catalog/schemas/%s", request.getFullName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, SchemaInfo.class, headers);
    }
}

