/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.CliTokenSource;
import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.HeaderFactory;
import com.databricks.sdk.core.oauth.Token;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabricksCliCredentialsProvider
implements CredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DatabricksCliCredentialsProvider.class);
    public static final String DATABRICKS_CLI = "databricks-cli";

    @Override
    public String authType() {
        return DATABRICKS_CLI;
    }

    private CliTokenSource getDatabricksCliTokenSource(DatabricksConfig config) {
        String cliPath = config.getDatabricksCliPath();
        if (cliPath == null) {
            cliPath = "databricks";
        }
        if (!cliPath.contains("/")) {
            cliPath = DatabricksCliCredentialsProvider.findExecutable(cliPath);
        }
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(cliPath, "auth", "token", "--host", config.getHost()));
        if (config.isAccountClient()) {
            cmd.add("--account-id");
            cmd.add(config.getAccountId());
        }
        return new CliTokenSource(cmd, "token_type", "access_token", "expiry", config::getAllEnv);
    }

    private static String findExecutable(String name) {
        String pathVal = System.getenv("PATH");
        StringTokenizer stringTokenizer = new StringTokenizer(pathVal, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            long size;
            Path path = Paths.get(stringTokenizer.nextToken(), name).toAbsolutePath().normalize();
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            try {
                size = Files.size(path);
            }
            catch (IOException e) {
                LOG.warn("Unable to get size of databricks cli: " + e.getMessage());
                return null;
            }
            if (size < 0x100000L) {
                LOG.info("Databricks CLI version <0.100.0 detected");
                return null;
            }
            return path.toString();
        }
        LOG.warn("Most likely the databricks CLI is not installed");
        return null;
    }

    @Override
    public HeaderFactory configure(DatabricksConfig config) {
        String host = config.getHost();
        if (host == null || !config.isAws()) {
            return null;
        }
        try {
            CliTokenSource tokenSource = this.getDatabricksCliTokenSource(config);
            tokenSource.getToken();
            return () -> {
                Token token = tokenSource.getToken();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Authorization", token.getTokenType() + " " + token.getAccessToken());
                return headers;
            };
        }
        catch (DatabricksException e) {
            String stderr = e.getMessage();
            if (stderr.contains("not found")) {
                LOG.warn("Most likely databricks CLI is not installed");
                return null;
            }
            if (stderr.contains("databricks OAuth is not")) {
                LOG.info("OAuth not configured or not available");
                return null;
            }
            throw e;
        }
    }
}

