/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settings;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.settings.CreateOboTokenRequest;
import com.databricks.sdk.service.settings.CreateOboTokenResponse;
import com.databricks.sdk.service.settings.DeleteTokenManagementRequest;
import com.databricks.sdk.service.settings.GetTokenManagementRequest;
import com.databricks.sdk.service.settings.GetTokenPermissionLevelsResponse;
import com.databricks.sdk.service.settings.ListTokenManagementRequest;
import com.databricks.sdk.service.settings.ListTokensResponse;
import com.databricks.sdk.service.settings.TokenInfo;
import com.databricks.sdk.service.settings.TokenManagementService;
import com.databricks.sdk.service.settings.TokenPermissions;
import com.databricks.sdk.service.settings.TokenPermissionsRequest;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class TokenManagementImpl
implements TokenManagementService {
    private final ApiClient apiClient;

    public TokenManagementImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateOboTokenResponse createOboToken(CreateOboTokenRequest request) {
        String path = "/api/2.0/token-management/on-behalf-of/tokens";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, CreateOboTokenResponse.class, headers);
    }

    @Override
    public void delete(DeleteTokenManagementRequest request) {
        String path = String.format("/api/2.0/token-management/tokens/%s", request.getTokenId());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public TokenInfo get(GetTokenManagementRequest request) {
        String path = String.format("/api/2.0/token-management/tokens/%s", request.getTokenId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, TokenInfo.class, headers);
    }

    @Override
    public GetTokenPermissionLevelsResponse getPermissionLevels() {
        String path = "/api/2.0/permissions/authorization/tokens/permissionLevels";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, GetTokenPermissionLevelsResponse.class, headers);
    }

    @Override
    public TokenPermissions getPermissions() {
        String path = "/api/2.0/permissions/authorization/tokens";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, TokenPermissions.class, headers);
    }

    @Override
    public ListTokensResponse list(ListTokenManagementRequest request) {
        String path = "/api/2.0/token-management/tokens";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListTokensResponse.class, headers);
    }

    @Override
    public TokenPermissions setPermissions(TokenPermissionsRequest request) {
        String path = "/api/2.0/permissions/authorization/tokens";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PUT(path, request, TokenPermissions.class, headers);
    }

    @Override
    public TokenPermissions updatePermissions(TokenPermissionsRequest request) {
        String path = "/api/2.0/permissions/authorization/tokens";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, TokenPermissions.class, headers);
    }
}

