/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.ConfigAttribute;
import com.databricks.sdk.core.DatabricksConfig;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;

class ConfigAttributeAccessor {
    private final ConfigAttribute configAttribute;
    private final Field field;
    private final String configFileAttribute;

    public ConfigAttributeAccessor(ConfigAttribute configAttribute, Field field) {
        this.configAttribute = configAttribute;
        this.field = field;
        this.configFileAttribute = this.toSnakeCase(field.getName());
    }

    public String getName() {
        return this.configFileAttribute;
    }

    public String getEnvVariable() {
        return this.configAttribute.env();
    }

    public Boolean isSensitive() {
        return this.configAttribute.sensitive();
    }

    public String getEnv(Map<String, String> getEnv) {
        if (this.configAttribute.env().isEmpty()) {
            return "";
        }
        return getEnv.get(this.configAttribute.env());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueOnConfig(DatabricksConfig cfg, String value) throws IllegalAccessException {
        Field field = this.field;
        synchronized (field) {
            this.field.setAccessible(true);
            if (this.field.getType() == String.class) {
                this.field.set(cfg, value);
            } else if (this.field.getType() == Integer.TYPE) {
                this.field.set(cfg, Integer.parseInt(value));
            } else if (this.field.getType() == Boolean.TYPE) {
                this.field.set(cfg, Boolean.parseBoolean(value));
            }
            this.field.setAccessible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueFromConfig(DatabricksConfig cfg) throws IllegalAccessException {
        Field field = this.field;
        synchronized (field) {
            this.field.setAccessible(true);
            Object value = this.field.get(cfg);
            this.field.setAccessible(false);
            return value;
        }
    }

    public String getAuthType() {
        return this.configAttribute.auth();
    }

    public String toString() {
        String repr = this.configFileAttribute;
        if (!Objects.equals(this.configAttribute.env(), "")) {
            repr = repr + "(env: " + this.configAttribute.env() + ")";
        }
        return repr;
    }

    public String getAsString(Object value) {
        return value.toString();
    }

    private String toSnakeCase(String name) {
        StringBuilder snakeCase = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                snakeCase.append("_").append(Character.toLowerCase(c));
                continue;
            }
            snakeCase.append(c);
        }
        return snakeCase.toString().toLowerCase();
    }
}

