/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.dashboards;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.dashboards.CreateDashboardRequest;
import com.databricks.sdk.service.dashboards.Dashboard;
import com.databricks.sdk.service.dashboards.GetDashboardRequest;
import com.databricks.sdk.service.dashboards.GetPublishedDashboardRequest;
import com.databricks.sdk.service.dashboards.LakeviewService;
import com.databricks.sdk.service.dashboards.MigrateDashboardRequest;
import com.databricks.sdk.service.dashboards.PublishRequest;
import com.databricks.sdk.service.dashboards.PublishedDashboard;
import com.databricks.sdk.service.dashboards.TrashDashboardRequest;
import com.databricks.sdk.service.dashboards.TrashDashboardResponse;
import com.databricks.sdk.service.dashboards.UnpublishDashboardRequest;
import com.databricks.sdk.service.dashboards.UnpublishDashboardResponse;
import com.databricks.sdk.service.dashboards.UpdateDashboardRequest;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class LakeviewImpl
implements LakeviewService {
    private final ApiClient apiClient;

    public LakeviewImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Dashboard create(CreateDashboardRequest request) {
        String path = "/api/2.0/lakeview/dashboards";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, Dashboard.class, headers);
    }

    @Override
    public Dashboard get(GetDashboardRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, Dashboard.class, headers);
    }

    @Override
    public PublishedDashboard getPublished(GetPublishedDashboardRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/published", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, PublishedDashboard.class, headers);
    }

    @Override
    public Dashboard migrate(MigrateDashboardRequest request) {
        String path = "/api/2.0/lakeview/dashboards/migrate";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, Dashboard.class, headers);
    }

    @Override
    public PublishedDashboard publish(PublishRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/published", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, PublishedDashboard.class, headers);
    }

    @Override
    public void trash(TrashDashboardRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, TrashDashboardResponse.class, headers);
    }

    @Override
    public void unpublish(UnpublishDashboardRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s/published", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, UnpublishDashboardResponse.class, headers);
    }

    @Override
    public Dashboard update(UpdateDashboardRequest request) {
        String path = String.format("/api/2.0/lakeview/dashboards/%s", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, Dashboard.class, headers);
    }
}

