/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.marketplace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.marketplace.ConsumerInstallationsImpl;
import com.databricks.sdk.service.marketplace.ConsumerInstallationsService;
import com.databricks.sdk.service.marketplace.CreateInstallationRequest;
import com.databricks.sdk.service.marketplace.DeleteInstallationRequest;
import com.databricks.sdk.service.marketplace.Installation;
import com.databricks.sdk.service.marketplace.InstallationDetail;
import com.databricks.sdk.service.marketplace.ListAllInstallationsRequest;
import com.databricks.sdk.service.marketplace.ListAllInstallationsResponse;
import com.databricks.sdk.service.marketplace.ListInstallationsRequest;
import com.databricks.sdk.service.marketplace.ListInstallationsResponse;
import com.databricks.sdk.service.marketplace.UpdateInstallationRequest;
import com.databricks.sdk.service.marketplace.UpdateInstallationResponse;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ConsumerInstallationsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerInstallationsAPI.class);
    private final ConsumerInstallationsService impl;

    public ConsumerInstallationsAPI(ApiClient apiClient) {
        this.impl = new ConsumerInstallationsImpl(apiClient);
    }

    public ConsumerInstallationsAPI(ConsumerInstallationsService mock) {
        this.impl = mock;
    }

    public Installation create(String listingId) {
        return this.create(new CreateInstallationRequest().setListingId(listingId));
    }

    public Installation create(CreateInstallationRequest request) {
        return this.impl.create(request);
    }

    public void delete(String listingId, String installationId) {
        this.delete(new DeleteInstallationRequest().setListingId(listingId).setInstallationId(installationId));
    }

    public void delete(DeleteInstallationRequest request) {
        this.impl.delete(request);
    }

    public Iterable<InstallationDetail> list(ListAllInstallationsRequest request) {
        return new Paginator(request, this.impl::list, ListAllInstallationsResponse::getInstallations, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<InstallationDetail> listListingInstallations(String listingId) {
        return this.listListingInstallations(new ListInstallationsRequest().setListingId(listingId));
    }

    public Iterable<InstallationDetail> listListingInstallations(ListInstallationsRequest request) {
        return new Paginator(request, this.impl::listListingInstallations, ListInstallationsResponse::getInstallations, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public UpdateInstallationResponse update(String listingId, String installationId, InstallationDetail installation) {
        return this.update(new UpdateInstallationRequest().setListingId(listingId).setInstallationId(installationId).setInstallation(installation));
    }

    public UpdateInstallationResponse update(UpdateInstallationRequest request) {
        return this.impl.update(request);
    }

    public ConsumerInstallationsService impl() {
        return this.impl;
    }
}

