/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iam;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.iam.AccountGroupsService;
import com.databricks.sdk.service.iam.DeleteAccountGroupRequest;
import com.databricks.sdk.service.iam.DeleteResponse;
import com.databricks.sdk.service.iam.GetAccountGroupRequest;
import com.databricks.sdk.service.iam.Group;
import com.databricks.sdk.service.iam.ListAccountGroupsRequest;
import com.databricks.sdk.service.iam.ListGroupsResponse;
import com.databricks.sdk.service.iam.PartialUpdate;
import com.databricks.sdk.service.iam.PatchResponse;
import com.databricks.sdk.service.iam.UpdateResponse;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class AccountGroupsImpl
implements AccountGroupsService {
    private final ApiClient apiClient;

    public AccountGroupsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Group create(Group request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Groups", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, Group.class, headers);
    }

    @Override
    public void delete(DeleteAccountGroupRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Groups/%s", this.apiClient.configuredAccountID(), request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, DeleteResponse.class, headers);
    }

    @Override
    public Group get(GetAccountGroupRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Groups/%s", this.apiClient.configuredAccountID(), request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, Group.class, headers);
    }

    @Override
    public ListGroupsResponse list(ListAccountGroupsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Groups", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListGroupsResponse.class, headers);
    }

    @Override
    public void patch(PartialUpdate request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Groups/%s", this.apiClient.configuredAccountID(), request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PATCH(path, request, PatchResponse.class, headers);
    }

    @Override
    public void update(Group request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Groups/%s", this.apiClient.configuredAccountID(), request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PUT(path, request, UpdateResponse.class, headers);
    }
}

