/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.compute;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.compute.CreateInstancePool;
import com.databricks.sdk.service.compute.CreateInstancePoolResponse;
import com.databricks.sdk.service.compute.DeleteInstancePool;
import com.databricks.sdk.service.compute.EditInstancePool;
import com.databricks.sdk.service.compute.GetInstancePool;
import com.databricks.sdk.service.compute.GetInstancePoolPermissionLevelsRequest;
import com.databricks.sdk.service.compute.GetInstancePoolPermissionLevelsResponse;
import com.databricks.sdk.service.compute.GetInstancePoolPermissionsRequest;
import com.databricks.sdk.service.compute.GetInstancePoolRequest;
import com.databricks.sdk.service.compute.InstancePoolPermissions;
import com.databricks.sdk.service.compute.InstancePoolPermissionsRequest;
import com.databricks.sdk.service.compute.InstancePoolsService;
import com.databricks.sdk.service.compute.ListInstancePools;
import com.databricks.sdk.support.Generated;

@Generated
class InstancePoolsImpl
implements InstancePoolsService {
    private final ApiClient apiClient;

    public InstancePoolsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateInstancePoolResponse create(CreateInstancePool request) {
        String path = "/api/2.0/instance-pools/create";
        return this.apiClient.POST(path, request, CreateInstancePoolResponse.class);
    }

    @Override
    public void delete(DeleteInstancePool request) {
        String path = "/api/2.0/instance-pools/delete";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void edit(EditInstancePool request) {
        String path = "/api/2.0/instance-pools/edit";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public GetInstancePool get(GetInstancePoolRequest request) {
        String path = "/api/2.0/instance-pools/get";
        return this.apiClient.GET(path, request, GetInstancePool.class);
    }

    @Override
    public GetInstancePoolPermissionLevelsResponse getInstancePoolPermissionLevels(GetInstancePoolPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/instance-pools/%s/permissionLevels", request.getInstancePoolId());
        return this.apiClient.GET(path, request, GetInstancePoolPermissionLevelsResponse.class);
    }

    @Override
    public InstancePoolPermissions getInstancePoolPermissions(GetInstancePoolPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/instance-pools/%s", request.getInstancePoolId());
        return this.apiClient.GET(path, request, InstancePoolPermissions.class);
    }

    @Override
    public ListInstancePools list() {
        String path = "/api/2.0/instance-pools/list";
        return this.apiClient.GET(path, ListInstancePools.class);
    }

    @Override
    public InstancePoolPermissions setInstancePoolPermissions(InstancePoolPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/instance-pools/%s", request.getInstancePoolId());
        return this.apiClient.PUT(path, request, InstancePoolPermissions.class);
    }

    @Override
    public InstancePoolPermissions updateInstancePoolPermissions(InstancePoolPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/instance-pools/%s", request.getInstancePoolId());
        return this.apiClient.PATCH(path, request, InstancePoolPermissions.class);
    }
}

