/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iam;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.iam.DeleteUserRequest;
import com.databricks.sdk.service.iam.GetPasswordPermissionLevelsResponse;
import com.databricks.sdk.service.iam.GetUserRequest;
import com.databricks.sdk.service.iam.ListUsersRequest;
import com.databricks.sdk.service.iam.ListUsersResponse;
import com.databricks.sdk.service.iam.PartialUpdate;
import com.databricks.sdk.service.iam.PasswordPermissions;
import com.databricks.sdk.service.iam.PasswordPermissionsRequest;
import com.databricks.sdk.service.iam.User;
import com.databricks.sdk.service.iam.UsersService;
import com.databricks.sdk.support.Generated;

@Generated
class UsersImpl
implements UsersService {
    private final ApiClient apiClient;

    public UsersImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public User create(User request) {
        String path = "/api/2.0/preview/scim/v2/Users";
        return this.apiClient.POST(path, request, User.class);
    }

    @Override
    public void delete(DeleteUserRequest request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public User get(GetUserRequest request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        return this.apiClient.GET(path, request, User.class);
    }

    @Override
    public GetPasswordPermissionLevelsResponse getPasswordPermissionLevels() {
        String path = "/api/2.0/permissions/authorization/passwords/permissionLevels";
        return this.apiClient.GET(path, GetPasswordPermissionLevelsResponse.class);
    }

    @Override
    public PasswordPermissions getPasswordPermissions() {
        String path = "/api/2.0/permissions/authorization/passwords";
        return this.apiClient.GET(path, PasswordPermissions.class);
    }

    @Override
    public ListUsersResponse list(ListUsersRequest request) {
        String path = "/api/2.0/preview/scim/v2/Users";
        return this.apiClient.GET(path, request, ListUsersResponse.class);
    }

    @Override
    public void patch(PartialUpdate request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        this.apiClient.PATCH(path, request, Void.class);
    }

    @Override
    public PasswordPermissions setPasswordPermissions(PasswordPermissionsRequest request) {
        String path = "/api/2.0/permissions/authorization/passwords";
        return this.apiClient.PUT(path, request, PasswordPermissions.class);
    }

    @Override
    public void update(User request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        this.apiClient.PUT(path, request, Void.class);
    }

    @Override
    public PasswordPermissions updatePasswordPermissions(PasswordPermissionsRequest request) {
        String path = "/api/2.0/permissions/authorization/passwords";
        return this.apiClient.PATCH(path, request, PasswordPermissions.class);
    }
}

