/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.serving;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.serving.BuildLogsRequest;
import com.databricks.sdk.service.serving.BuildLogsResponse;
import com.databricks.sdk.service.serving.CreateServingEndpoint;
import com.databricks.sdk.service.serving.DeleteServingEndpointRequest;
import com.databricks.sdk.service.serving.EndpointCoreConfigInput;
import com.databricks.sdk.service.serving.ExportMetricsRequest;
import com.databricks.sdk.service.serving.GetServingEndpointPermissionLevelsRequest;
import com.databricks.sdk.service.serving.GetServingEndpointPermissionLevelsResponse;
import com.databricks.sdk.service.serving.GetServingEndpointPermissionsRequest;
import com.databricks.sdk.service.serving.GetServingEndpointRequest;
import com.databricks.sdk.service.serving.ListEndpointsResponse;
import com.databricks.sdk.service.serving.LogsRequest;
import com.databricks.sdk.service.serving.QueryEndpointResponse;
import com.databricks.sdk.service.serving.QueryRequest;
import com.databricks.sdk.service.serving.ServerLogsResponse;
import com.databricks.sdk.service.serving.ServingEndpointDetailed;
import com.databricks.sdk.service.serving.ServingEndpointPermissions;
import com.databricks.sdk.service.serving.ServingEndpointPermissionsRequest;
import com.databricks.sdk.service.serving.ServingEndpointsService;
import com.databricks.sdk.support.Generated;

@Generated
class ServingEndpointsImpl
implements ServingEndpointsService {
    private final ApiClient apiClient;

    public ServingEndpointsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public BuildLogsResponse buildLogs(BuildLogsRequest request) {
        String path = String.format("/api/2.0/serving-endpoints/%s/served-models/%s/build-logs", request.getName(), request.getServedModelName());
        return this.apiClient.GET(path, request, BuildLogsResponse.class);
    }

    @Override
    public ServingEndpointDetailed create(CreateServingEndpoint request) {
        String path = "/api/2.0/serving-endpoints";
        return this.apiClient.POST(path, request, ServingEndpointDetailed.class);
    }

    @Override
    public void delete(DeleteServingEndpointRequest request) {
        String path = String.format("/api/2.0/serving-endpoints/%s", request.getName());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public void exportMetrics(ExportMetricsRequest request) {
        String path = String.format("/api/2.0/serving-endpoints/%s/metrics", request.getName());
        this.apiClient.GET(path, request, Void.class);
    }

    @Override
    public ServingEndpointDetailed get(GetServingEndpointRequest request) {
        String path = String.format("/api/2.0/serving-endpoints/%s", request.getName());
        return this.apiClient.GET(path, request, ServingEndpointDetailed.class);
    }

    @Override
    public GetServingEndpointPermissionLevelsResponse getServingEndpointPermissionLevels(GetServingEndpointPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/serving-endpoints/%s/permissionLevels", request.getServingEndpointId());
        return this.apiClient.GET(path, request, GetServingEndpointPermissionLevelsResponse.class);
    }

    @Override
    public ServingEndpointPermissions getServingEndpointPermissions(GetServingEndpointPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/serving-endpoints/%s", request.getServingEndpointId());
        return this.apiClient.GET(path, request, ServingEndpointPermissions.class);
    }

    @Override
    public ListEndpointsResponse list() {
        String path = "/api/2.0/serving-endpoints";
        return this.apiClient.GET(path, ListEndpointsResponse.class);
    }

    @Override
    public ServerLogsResponse logs(LogsRequest request) {
        String path = String.format("/api/2.0/serving-endpoints/%s/served-models/%s/logs", request.getName(), request.getServedModelName());
        return this.apiClient.GET(path, request, ServerLogsResponse.class);
    }

    @Override
    public QueryEndpointResponse query(QueryRequest request) {
        String path = String.format("/serving-endpoints/%s/invocations", request.getName());
        return this.apiClient.POST(path, request, QueryEndpointResponse.class);
    }

    @Override
    public ServingEndpointPermissions setServingEndpointPermissions(ServingEndpointPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/serving-endpoints/%s", request.getServingEndpointId());
        return this.apiClient.PUT(path, request, ServingEndpointPermissions.class);
    }

    @Override
    public ServingEndpointDetailed updateConfig(EndpointCoreConfigInput request) {
        String path = String.format("/api/2.0/serving-endpoints/%s/config", request.getName());
        return this.apiClient.PUT(path, request, ServingEndpointDetailed.class);
    }

    @Override
    public ServingEndpointPermissions updateServingEndpointPermissions(ServingEndpointPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/serving-endpoints/%s", request.getServingEndpointId());
        return this.apiClient.PATCH(path, request, ServingEndpointPermissions.class);
    }
}

