/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sql;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.sql.CreateWarehouseRequest;
import com.databricks.sdk.service.sql.CreateWarehouseResponse;
import com.databricks.sdk.service.sql.DeleteWarehouseRequest;
import com.databricks.sdk.service.sql.EditWarehouseRequest;
import com.databricks.sdk.service.sql.GetWarehousePermissionLevelsRequest;
import com.databricks.sdk.service.sql.GetWarehousePermissionLevelsResponse;
import com.databricks.sdk.service.sql.GetWarehousePermissionsRequest;
import com.databricks.sdk.service.sql.GetWarehouseRequest;
import com.databricks.sdk.service.sql.GetWarehouseResponse;
import com.databricks.sdk.service.sql.GetWorkspaceWarehouseConfigResponse;
import com.databricks.sdk.service.sql.ListWarehousesRequest;
import com.databricks.sdk.service.sql.ListWarehousesResponse;
import com.databricks.sdk.service.sql.SetWorkspaceWarehouseConfigRequest;
import com.databricks.sdk.service.sql.StartRequest;
import com.databricks.sdk.service.sql.StopRequest;
import com.databricks.sdk.service.sql.WarehousePermissions;
import com.databricks.sdk.service.sql.WarehousePermissionsRequest;
import com.databricks.sdk.service.sql.WarehousesService;
import com.databricks.sdk.support.Generated;

@Generated
class WarehousesImpl
implements WarehousesService {
    private final ApiClient apiClient;

    public WarehousesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateWarehouseResponse create(CreateWarehouseRequest request) {
        String path = "/api/2.0/sql/warehouses";
        return this.apiClient.POST(path, request, CreateWarehouseResponse.class);
    }

    @Override
    public void delete(DeleteWarehouseRequest request) {
        String path = String.format("/api/2.0/sql/warehouses/%s", request.getId());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public void edit(EditWarehouseRequest request) {
        String path = String.format("/api/2.0/sql/warehouses/%s/edit", request.getId());
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public GetWarehouseResponse get(GetWarehouseRequest request) {
        String path = String.format("/api/2.0/sql/warehouses/%s", request.getId());
        return this.apiClient.GET(path, request, GetWarehouseResponse.class);
    }

    @Override
    public GetWarehousePermissionLevelsResponse getWarehousePermissionLevels(GetWarehousePermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/warehouses/%s/permissionLevels", request.getWarehouseId());
        return this.apiClient.GET(path, request, GetWarehousePermissionLevelsResponse.class);
    }

    @Override
    public WarehousePermissions getWarehousePermissions(GetWarehousePermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/warehouses/%s", request.getWarehouseId());
        return this.apiClient.GET(path, request, WarehousePermissions.class);
    }

    @Override
    public GetWorkspaceWarehouseConfigResponse getWorkspaceWarehouseConfig() {
        String path = "/api/2.0/sql/config/warehouses";
        return this.apiClient.GET(path, GetWorkspaceWarehouseConfigResponse.class);
    }

    @Override
    public ListWarehousesResponse list(ListWarehousesRequest request) {
        String path = "/api/2.0/sql/warehouses";
        return this.apiClient.GET(path, request, ListWarehousesResponse.class);
    }

    @Override
    public WarehousePermissions setWarehousePermissions(WarehousePermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/warehouses/%s", request.getWarehouseId());
        return this.apiClient.PUT(path, request, WarehousePermissions.class);
    }

    @Override
    public void setWorkspaceWarehouseConfig(SetWorkspaceWarehouseConfigRequest request) {
        String path = "/api/2.0/sql/config/warehouses";
        this.apiClient.PUT(path, request, Void.class);
    }

    @Override
    public void start(StartRequest request) {
        String path = String.format("/api/2.0/sql/warehouses/%s/start", request.getId());
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void stop(StopRequest request) {
        String path = String.format("/api/2.0/sql/warehouses/%s/stop", request.getId());
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public WarehousePermissions updateWarehousePermissions(WarehousePermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/warehouses/%s", request.getWarehouseId());
        return this.apiClient.PATCH(path, request, WarehousePermissions.class);
    }
}

