/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.utils.Environment;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class UserAgent {
    private static String product = "unknown";
    private static String productVersion = "0.0.0";
    private static final ArrayList<Info> otherInfo = new ArrayList();
    private static final String version = "0.35.0";
    private static final String semVerCore = "(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)";
    private static final String semVerPrerelease = "(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?";
    private static final String semVerBuildmetadata = "(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?";
    private static final Pattern regexpSemVer = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private static final Pattern regexpAlphanum = Pattern.compile("^[0-9A-Za-z_\\.\\+-]+$");
    private static final Pattern regexpAlphanumInverse = Pattern.compile("[^0-9A-Za-z_\\.\\+-]");
    protected static volatile String cicdProvider = null;
    protected static Environment env = null;

    public static void withProduct(String product, String productVersion) {
        UserAgent.product = product;
        UserAgent.productVersion = productVersion;
    }

    public static String sanitize(String s) {
        return regexpAlphanumInverse.matcher(s).replaceAll("-");
    }

    public static boolean matchSemVer(String s) throws IllegalArgumentException {
        if (regexpSemVer.matcher(s).matches()) {
            return true;
        }
        throw new IllegalArgumentException("Invalid semver string: " + s);
    }

    public static boolean matchAlphanum(String s) throws IllegalArgumentException {
        if (regexpAlphanum.matcher(s).matches()) {
            return true;
        }
        throw new IllegalArgumentException("Invalid alphanumeric string: " + s);
    }

    public static boolean matchAlphanumOrSemVer(String s) throws IllegalArgumentException {
        if (regexpAlphanum.matcher(s).matches() || regexpSemVer.matcher(s).matches()) {
            return true;
        }
        throw new IllegalArgumentException("Invalid alphanumeric or semver string: " + s);
    }

    public static void withPartner(String partner) {
        UserAgent.withOtherInfo("partner", partner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withOtherInfo(String key, String value) {
        UserAgent.matchAlphanum(key);
        UserAgent.matchAlphanumOrSemVer(value);
        ArrayList<Info> arrayList = otherInfo;
        synchronized (arrayList) {
            otherInfo.add(new Info(key, value));
        }
    }

    private static String osName() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("mac")) {
            return "darwin";
        }
        if (osName.contains("linux")) {
            return "linux";
        }
        if (osName.contains("win")) {
            return "windows";
        }
        return "unknown";
    }

    private static String jvmVersion() {
        String jvmVersion = System.getProperty("java.version");
        String[] split = jvmVersion.split("_");
        return split[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String asString() {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(String.format("%s/%s", product, productVersion));
        segments.add(String.format("databricks-sdk-java/%s", version));
        segments.add(String.format("jvm/%s", UserAgent.jvmVersion()));
        segments.add(String.format("os/%s", UserAgent.osName()));
        String cicdProvider = UserAgent.cicdProvider();
        if (!cicdProvider.isEmpty()) {
            segments.add(String.format("cicd/%s", cicdProvider));
        }
        ArrayList<Info> arrayList = otherInfo;
        synchronized (arrayList) {
            segments.addAll(otherInfo.stream().map(e -> String.format("%s/%s", e.getKey(), e.getValue())).collect(Collectors.toSet()));
        }
        return segments.stream().collect(Collectors.joining(" "));
    }

    private static List<CicdProvider> listCiCdProviders() {
        return Arrays.asList(new CicdProvider("github", Collections.singletonList(new EnvVar("GITHUB_ACTIONS", "true"))), new CicdProvider("gitlab", Collections.singletonList(new EnvVar("GITLAB_CI", "true"))), new CicdProvider("jenkins", Collections.singletonList(new EnvVar("JENKINS_URL", ""))), new CicdProvider("azure-devops", Collections.singletonList(new EnvVar("TF_BUILD", "True"))), new CicdProvider("circle", Collections.singletonList(new EnvVar("CIRCLECI", "true"))), new CicdProvider("travis", Collections.singletonList(new EnvVar("TRAVIS", "true"))), new CicdProvider("bitbucket", Collections.singletonList(new EnvVar("BITBUCKET_BUILD_NUMBER", ""))), new CicdProvider("google-cloud-build", Arrays.asList(new EnvVar("PROJECT_ID", ""), new EnvVar("BUILD_ID", ""), new EnvVar("PROJECT_NUMBER", ""), new EnvVar("LOCATION", ""))), new CicdProvider("aws-code-build", Collections.singletonList(new EnvVar("CODEBUILD_BUILD_ARN", ""))), new CicdProvider("tf-cloud", Collections.singletonList(new EnvVar("TFC_RUN_ID", ""))));
    }

    private static String lookupCiCdProvider(Environment env) {
        for (CicdProvider provider : UserAgent.listCiCdProviders()) {
            if (!provider.detect(env)) continue;
            return provider.name;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String cicdProvider() {
        if (cicdProvider != null) return cicdProvider;
        Class<UserAgent> clazz = UserAgent.class;
        synchronized (UserAgent.class) {
            if (cicdProvider != null) return cicdProvider;
            cicdProvider = UserAgent.lookupCiCdProvider(UserAgent.env());
            // ** MonitorExit[var0] (shouldn't be in output)
            return cicdProvider;
        }
    }

    private static Environment env() {
        if (env == null) {
            env = new Environment(System.getenv(), System.getenv("PATH").split(File.pathSeparator), System.getProperty("os.name"));
        }
        return env;
    }

    private static class CicdProvider {
        private final String name;
        private final List<EnvVar> envVars;

        public CicdProvider(String name, List<EnvVar> envVars) {
            this.name = name;
            this.envVars = envVars;
        }

        public boolean detect(Environment env) {
            for (EnvVar envVar : this.envVars) {
                String value = env.get(envVar.name);
                if (value == null) {
                    return false;
                }
                if (envVar.expectedValue.isEmpty() || value.equals(envVar.expectedValue)) continue;
                return false;
            }
            return true;
        }
    }

    private static class EnvVar {
        private final String name;
        private final String expectedValue;

        public EnvVar(String name, String expectedValue) {
            this.name = name;
            this.expectedValue = expectedValue;
        }
    }

    private static class Info {
        private String key;
        private String value;

        public Info(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

