/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settings;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.settings.AccountIpAccessListsService;
import com.databricks.sdk.service.settings.CreateIpAccessList;
import com.databricks.sdk.service.settings.CreateIpAccessListResponse;
import com.databricks.sdk.service.settings.DeleteAccountIpAccessListRequest;
import com.databricks.sdk.service.settings.DeleteResponse;
import com.databricks.sdk.service.settings.GetAccountIpAccessListRequest;
import com.databricks.sdk.service.settings.GetIpAccessListResponse;
import com.databricks.sdk.service.settings.GetIpAccessListsResponse;
import com.databricks.sdk.service.settings.ReplaceIpAccessList;
import com.databricks.sdk.service.settings.ReplaceResponse;
import com.databricks.sdk.service.settings.UpdateIpAccessList;
import com.databricks.sdk.service.settings.UpdateResponse;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class AccountIpAccessListsImpl
implements AccountIpAccessListsService {
    private final ApiClient apiClient;

    public AccountIpAccessListsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateIpAccessListResponse create(CreateIpAccessList request) {
        String path = String.format("/api/2.0/accounts/%s/ip-access-lists", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateIpAccessListResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteAccountIpAccessListRequest request) {
        String path = String.format("/api/2.0/accounts/%s/ip-access-lists/%s", this.apiClient.configuredAccountID(), request.getIpAccessListId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetIpAccessListResponse get(GetAccountIpAccessListRequest request) {
        String path = String.format("/api/2.0/accounts/%s/ip-access-lists/%s", this.apiClient.configuredAccountID(), request.getIpAccessListId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetIpAccessListResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetIpAccessListsResponse list() {
        String path = String.format("/api/2.0/accounts/%s/ip-access-lists", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetIpAccessListsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void replace(ReplaceIpAccessList request) {
        String path = String.format("/api/2.0/accounts/%s/ip-access-lists/%s", this.apiClient.configuredAccountID(), request.getIpAccessListId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, ReplaceResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(UpdateIpAccessList request) {
        String path = String.format("/api/2.0/accounts/%s/ip-access-lists/%s", this.apiClient.configuredAccountID(), request.getIpAccessListId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, UpdateResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

