/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sharing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.sharing.CreateProvider;
import com.databricks.sdk.service.sharing.DeleteProviderRequest;
import com.databricks.sdk.service.sharing.DeleteResponse;
import com.databricks.sdk.service.sharing.GetProviderRequest;
import com.databricks.sdk.service.sharing.ListProviderSharesResponse;
import com.databricks.sdk.service.sharing.ListProvidersRequest;
import com.databricks.sdk.service.sharing.ListProvidersResponse;
import com.databricks.sdk.service.sharing.ListSharesRequest;
import com.databricks.sdk.service.sharing.ProviderInfo;
import com.databricks.sdk.service.sharing.ProvidersService;
import com.databricks.sdk.service.sharing.UpdateProvider;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class ProvidersImpl
implements ProvidersService {
    private final ApiClient apiClient;

    public ProvidersImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public ProviderInfo create(CreateProvider request) {
        String path = "/api/2.1/unity-catalog/providers";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ProviderInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteProviderRequest request) {
        String path = String.format("/api/2.1/unity-catalog/providers/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ProviderInfo get(GetProviderRequest request) {
        String path = String.format("/api/2.1/unity-catalog/providers/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ProviderInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListProvidersResponse list(ListProvidersRequest request) {
        String path = "/api/2.1/unity-catalog/providers";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListProvidersResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListProviderSharesResponse listShares(ListSharesRequest request) {
        String path = String.format("/api/2.1/unity-catalog/providers/%s/shares", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListProviderSharesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ProviderInfo update(UpdateProvider request) {
        String path = String.format("/api/2.1/unity-catalog/providers/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ProviderInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

