/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sharing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.PermissionsList;
import com.databricks.sdk.service.sharing.CreateShare;
import com.databricks.sdk.service.sharing.DeleteResponse;
import com.databricks.sdk.service.sharing.DeleteShareRequest;
import com.databricks.sdk.service.sharing.GetShareRequest;
import com.databricks.sdk.service.sharing.ListSharesRequest;
import com.databricks.sdk.service.sharing.ListSharesResponse;
import com.databricks.sdk.service.sharing.ShareInfo;
import com.databricks.sdk.service.sharing.SharePermissionsRequest;
import com.databricks.sdk.service.sharing.SharesService;
import com.databricks.sdk.service.sharing.UpdatePermissionsResponse;
import com.databricks.sdk.service.sharing.UpdateShare;
import com.databricks.sdk.service.sharing.UpdateSharePermissions;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class SharesImpl
implements SharesService {
    private final ApiClient apiClient;

    public SharesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public ShareInfo create(CreateShare request) {
        String path = "/api/2.1/unity-catalog/shares";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ShareInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteShareRequest request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ShareInfo get(GetShareRequest request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ShareInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListSharesResponse list(ListSharesRequest request) {
        String path = "/api/2.1/unity-catalog/shares";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListSharesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PermissionsList sharePermissions(SharePermissionsRequest request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s/permissions", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, PermissionsList.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ShareInfo update(UpdateShare request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ShareInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void updatePermissions(UpdateSharePermissions request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s/permissions", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, UpdatePermissionsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

