/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.CreateCredentialRequest;
import com.databricks.sdk.service.catalog.CredentialInfo;
import com.databricks.sdk.service.catalog.CredentialsService;
import com.databricks.sdk.service.catalog.DeleteCredentialRequest;
import com.databricks.sdk.service.catalog.DeleteCredentialResponse;
import com.databricks.sdk.service.catalog.GenerateTemporaryServiceCredentialRequest;
import com.databricks.sdk.service.catalog.GetCredentialRequest;
import com.databricks.sdk.service.catalog.ListCredentialsRequest;
import com.databricks.sdk.service.catalog.ListCredentialsResponse;
import com.databricks.sdk.service.catalog.TemporaryCredentials;
import com.databricks.sdk.service.catalog.UpdateCredentialRequest;
import com.databricks.sdk.service.catalog.ValidateCredentialRequest;
import com.databricks.sdk.service.catalog.ValidateCredentialResponse;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class CredentialsImpl
implements CredentialsService {
    private final ApiClient apiClient;

    public CredentialsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CredentialInfo createCredential(CreateCredentialRequest request) {
        String path = "/api/2.1/unity-catalog/credentials";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CredentialInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteCredential(DeleteCredentialRequest request) {
        String path = String.format("/api/2.1/unity-catalog/credentials/%s", request.getNameArg());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteCredentialResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public TemporaryCredentials generateTemporaryServiceCredential(GenerateTemporaryServiceCredentialRequest request) {
        String path = "/api/2.1/unity-catalog/temporary-service-credentials";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, TemporaryCredentials.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CredentialInfo getCredential(GetCredentialRequest request) {
        String path = String.format("/api/2.1/unity-catalog/credentials/%s", request.getNameArg());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, CredentialInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListCredentialsResponse listCredentials(ListCredentialsRequest request) {
        String path = "/api/2.1/unity-catalog/credentials";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListCredentialsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CredentialInfo updateCredential(UpdateCredentialRequest request) {
        String path = String.format("/api/2.1/unity-catalog/credentials/%s", request.getNameArg());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CredentialInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ValidateCredentialResponse validateCredential(ValidateCredentialRequest request) {
        String path = "/api/2.1/unity-catalog/validate-credentials";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ValidateCredentialResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

