/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sql;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.sql.AlertV2;
import com.databricks.sdk.service.sql.AlertsV2Impl;
import com.databricks.sdk.service.sql.AlertsV2Service;
import com.databricks.sdk.service.sql.CreateAlertV2Request;
import com.databricks.sdk.service.sql.GetAlertV2Request;
import com.databricks.sdk.service.sql.ListAlertsV2Request;
import com.databricks.sdk.service.sql.ListAlertsV2Response;
import com.databricks.sdk.service.sql.TrashAlertV2Request;
import com.databricks.sdk.service.sql.UpdateAlertV2Request;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AlertsV2API {
    private static final Logger LOG = LoggerFactory.getLogger(AlertsV2API.class);
    private final AlertsV2Service impl;

    public AlertsV2API(ApiClient apiClient) {
        this.impl = new AlertsV2Impl(apiClient);
    }

    public AlertsV2API(AlertsV2Service mock) {
        this.impl = mock;
    }

    public AlertV2 createAlert(CreateAlertV2Request request) {
        return this.impl.createAlert(request);
    }

    public AlertV2 getAlert(String id) {
        return this.getAlert(new GetAlertV2Request().setId(id));
    }

    public AlertV2 getAlert(GetAlertV2Request request) {
        return this.impl.getAlert(request);
    }

    public Iterable<AlertV2> listAlerts(ListAlertsV2Request request) {
        return new Paginator(request, this.impl::listAlerts, ListAlertsV2Response::getResults, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public void trashAlert(String id) {
        this.trashAlert(new TrashAlertV2Request().setId(id));
    }

    public void trashAlert(TrashAlertV2Request request) {
        this.impl.trashAlert(request);
    }

    public AlertV2 updateAlert(String id, String updateMask) {
        return this.updateAlert(new UpdateAlertV2Request().setId(id).setUpdateMask(updateMask));
    }

    public AlertV2 updateAlert(UpdateAlertV2Request request) {
        return this.impl.updateAlert(request);
    }

    public AlertsV2Service impl() {
        return this.impl;
    }
}

