/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.vectorsearch;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.vectorsearch.CreateEndpoint;
import com.databricks.sdk.service.vectorsearch.DeleteEndpointRequest;
import com.databricks.sdk.service.vectorsearch.DeleteEndpointResponse;
import com.databricks.sdk.service.vectorsearch.EndpointInfo;
import com.databricks.sdk.service.vectorsearch.GetEndpointRequest;
import com.databricks.sdk.service.vectorsearch.ListEndpointResponse;
import com.databricks.sdk.service.vectorsearch.ListEndpointsRequest;
import com.databricks.sdk.service.vectorsearch.PatchEndpointBudgetPolicyRequest;
import com.databricks.sdk.service.vectorsearch.PatchEndpointBudgetPolicyResponse;
import com.databricks.sdk.service.vectorsearch.UpdateEndpointCustomTagsRequest;
import com.databricks.sdk.service.vectorsearch.UpdateEndpointCustomTagsResponse;
import com.databricks.sdk.service.vectorsearch.VectorSearchEndpointsService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class VectorSearchEndpointsImpl
implements VectorSearchEndpointsService {
    private final ApiClient apiClient;

    public VectorSearchEndpointsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public EndpointInfo createEndpoint(CreateEndpoint request) {
        String path = "/api/2.0/vector-search/endpoints";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, EndpointInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteEndpoint(DeleteEndpointRequest request) {
        String path = String.format("/api/2.0/vector-search/endpoints/%s", request.getEndpointName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteEndpointResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public EndpointInfo getEndpoint(GetEndpointRequest request) {
        String path = String.format("/api/2.0/vector-search/endpoints/%s", request.getEndpointName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, EndpointInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListEndpointResponse listEndpoints(ListEndpointsRequest request) {
        String path = "/api/2.0/vector-search/endpoints";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListEndpointResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PatchEndpointBudgetPolicyResponse updateEndpointBudgetPolicy(PatchEndpointBudgetPolicyRequest request) {
        String path = String.format("/api/2.0/vector-search/endpoints/%s/budget-policy", request.getEndpointName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, PatchEndpointBudgetPolicyResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public UpdateEndpointCustomTagsResponse updateEndpointCustomTags(UpdateEndpointCustomTagsRequest request) {
        String path = String.format("/api/2.0/vector-search/endpoints/%s/tags", request.getEndpointName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, UpdateEndpointCustomTagsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

