/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.oauth.AuthParameterPosition;
import com.databricks.sdk.core.oauth.CachedTokenSource;
import com.databricks.sdk.core.oauth.ClientCredentials;
import com.databricks.sdk.core.oauth.OAuthHeaderFactory;
import com.databricks.sdk.core.utils.AzureUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;

public class AzureServicePrincipalCredentialsProvider
implements CredentialsProvider {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public String authType() {
        return "azure-client-secret";
    }

    @Override
    public OAuthHeaderFactory configure(DatabricksConfig config) {
        if (!config.isAzure() || config.getAzureClientId() == null || config.getAzureClientSecret() == null || config.getAzureTenantId() == null) {
            return null;
        }
        AzureUtils.ensureHostPresent(config, this.mapper, AzureServicePrincipalCredentialsProvider::tokenSourceFor);
        CachedTokenSource inner = AzureServicePrincipalCredentialsProvider.tokenSourceFor(config, config.getEffectiveAzureLoginAppId());
        CachedTokenSource cloud = AzureServicePrincipalCredentialsProvider.tokenSourceFor(config, config.getAzureEnvironment().getServiceManagementEndpoint());
        return OAuthHeaderFactory.fromSuppliers(inner::getToken, () -> {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + inner.getToken().getAccessToken());
            AzureUtils.addWorkspaceResourceId(config, headers);
            AzureUtils.addSpManagementToken(cloud, headers);
            return headers;
        });
    }

    private static CachedTokenSource tokenSourceFor(DatabricksConfig config, String resource) {
        String aadEndpoint = config.getAzureEnvironment().getActiveDirectoryEndpoint();
        String tokenUrl = aadEndpoint + config.getAzureTenantId() + "/oauth2/token";
        HashMap<String, String> endpointParams = new HashMap<String, String>();
        endpointParams.put("resource", resource);
        ClientCredentials clientCredentials = new ClientCredentials.Builder().withHttpClient(config.getHttpClient()).withClientId(config.getAzureClientId()).withClientSecret(config.getAzureClientSecret()).withTokenUrl(tokenUrl).withEndpointParametersSupplier(() -> endpointParams).withAuthParameterPosition(AuthParameterPosition.BODY).build();
        return new CachedTokenSource.Builder(clientCredentials).setAsyncDisabled(config.getDisableAsyncTokenRefresh()).build();
    }
}

